/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.authentication;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.Map;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.core.OAuth2TokenType;
import org.springframework.security.oauth2.core.endpoint.OAuth2AuthorizationRequest;
import org.springframework.security.oauth2.server.authorization.OAuth2Authorization;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationService;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2ClientAuthenticationToken;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClient;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClientRepository;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class OAuth2ClientAuthenticationProvider
implements AuthenticationProvider {
    private static final OAuth2TokenType AUTHORIZATION_CODE_TOKEN_TYPE = new OAuth2TokenType("code");
    private final RegisteredClientRepository registeredClientRepository;
    private final OAuth2AuthorizationService authorizationService;

    public OAuth2ClientAuthenticationProvider(RegisteredClientRepository registeredClientRepository, OAuth2AuthorizationService authorizationService) {
        Assert.notNull((Object)registeredClientRepository, (String)"registeredClientRepository cannot be null");
        Assert.notNull((Object)authorizationService, (String)"authorizationService cannot be null");
        this.registeredClientRepository = registeredClientRepository;
        this.authorizationService = authorizationService;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        OAuth2ClientAuthenticationToken clientAuthentication = (OAuth2ClientAuthenticationToken)authentication;
        String clientId = clientAuthentication.getPrincipal().toString();
        RegisteredClient registeredClient = this.registeredClientRepository.findByClientId(clientId);
        if (registeredClient == null) {
            OAuth2ClientAuthenticationProvider.throwInvalidClient();
        }
        if (!registeredClient.getClientAuthenticationMethods().contains(clientAuthentication.getClientAuthenticationMethod())) {
            OAuth2ClientAuthenticationProvider.throwInvalidClient();
        }
        boolean authenticatedCredentials = false;
        if (clientAuthentication.getCredentials() != null) {
            String clientSecret = clientAuthentication.getCredentials().toString();
            if (!registeredClient.getClientSecret().equals(clientSecret)) {
                OAuth2ClientAuthenticationProvider.throwInvalidClient();
            }
            authenticatedCredentials = true;
        }
        boolean bl = authenticatedCredentials = authenticatedCredentials || this.authenticatePkceIfAvailable(clientAuthentication, registeredClient);
        if (!authenticatedCredentials) {
            OAuth2ClientAuthenticationProvider.throwInvalidClient();
        }
        return new OAuth2ClientAuthenticationToken(registeredClient);
    }

    public boolean supports(Class<?> authentication) {
        return OAuth2ClientAuthenticationToken.class.isAssignableFrom(authentication);
    }

    private boolean authenticatePkceIfAvailable(OAuth2ClientAuthenticationToken clientAuthentication, RegisteredClient registeredClient) {
        OAuth2AuthorizationRequest authorizationRequest;
        String codeChallenge;
        Map<String, Object> parameters = clientAuthentication.getAdditionalParameters();
        if (CollectionUtils.isEmpty(parameters) || !OAuth2ClientAuthenticationProvider.authorizationCodeGrant(parameters)) {
            return false;
        }
        OAuth2Authorization authorization = this.authorizationService.findByToken((String)parameters.get("code"), AUTHORIZATION_CODE_TOKEN_TYPE);
        if (authorization == null) {
            OAuth2ClientAuthenticationProvider.throwInvalidClient();
        }
        if (!StringUtils.hasText((String)(codeChallenge = (String)(authorizationRequest = (OAuth2AuthorizationRequest)authorization.getAttribute(OAuth2AuthorizationRequest.class.getName())).getAdditionalParameters().get("code_challenge"))) && registeredClient.getClientSettings().requireProofKey()) {
            OAuth2ClientAuthenticationProvider.throwInvalidClient();
        }
        String codeChallengeMethod = (String)authorizationRequest.getAdditionalParameters().get("code_challenge_method");
        String codeVerifier = (String)parameters.get("code_verifier");
        if (!OAuth2ClientAuthenticationProvider.codeVerifierValid(codeVerifier, codeChallenge, codeChallengeMethod)) {
            OAuth2ClientAuthenticationProvider.throwInvalidClient();
        }
        return true;
    }

    private static boolean authorizationCodeGrant(Map<String, Object> parameters) {
        return AuthorizationGrantType.AUTHORIZATION_CODE.getValue().equals(parameters.get("grant_type")) && parameters.get("code") != null;
    }

    private static boolean codeVerifierValid(String codeVerifier, String codeChallenge, String codeChallengeMethod) {
        if (!StringUtils.hasText((String)codeVerifier)) {
            return false;
        }
        if (!StringUtils.hasText((String)codeChallengeMethod) || "plain".equals(codeChallengeMethod)) {
            return codeVerifier.equals(codeChallenge);
        }
        if ("S256".equals(codeChallengeMethod)) {
            try {
                MessageDigest md = MessageDigest.getInstance("SHA-256");
                byte[] digest = md.digest(codeVerifier.getBytes(StandardCharsets.US_ASCII));
                String encodedVerifier = Base64.getUrlEncoder().withoutPadding().encodeToString(digest);
                return encodedVerifier.equals(codeChallenge);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
        }
        throw new OAuth2AuthenticationException(new OAuth2Error("server_error"));
    }

    private static void throwInvalidClient() {
        throw new OAuth2AuthenticationException(new OAuth2Error("invalid_client"));
    }
}

