/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.springframework.lang.Nullable;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.OAuth2TokenType;
import org.springframework.security.oauth2.core.context.Context;
import org.springframework.security.oauth2.server.authorization.OAuth2Authorization;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClient;
import org.springframework.util.Assert;

public interface OAuth2TokenContext
extends Context {
    default public RegisteredClient getRegisteredClient() {
        return this.get(RegisteredClient.class);
    }

    default public <T extends Authentication> T getPrincipal() {
        return (T)((Authentication)this.get(AbstractBuilder.PRINCIPAL_AUTHENTICATION_KEY));
    }

    @Nullable
    default public OAuth2Authorization getAuthorization() {
        return this.get(OAuth2Authorization.class);
    }

    default public Set<String> getAuthorizedScopes() {
        return this.hasKey(OAuth2Authorization.AUTHORIZED_SCOPE_ATTRIBUTE_NAME) ? (Set)this.get(OAuth2Authorization.AUTHORIZED_SCOPE_ATTRIBUTE_NAME) : Collections.emptySet();
    }

    default public OAuth2TokenType getTokenType() {
        return this.get(OAuth2TokenType.class);
    }

    default public AuthorizationGrantType getAuthorizationGrantType() {
        return this.get(AuthorizationGrantType.class);
    }

    default public <T extends Authentication> T getAuthorizationGrant() {
        return (T)((Authentication)this.get(AbstractBuilder.AUTHORIZATION_GRANT_AUTHENTICATION_KEY));
    }

    public static abstract class AbstractBuilder<T extends OAuth2TokenContext, B extends AbstractBuilder<T, B>> {
        private static final String PRINCIPAL_AUTHENTICATION_KEY = Authentication.class.getName().concat(".PRINCIPAL");
        private static final String AUTHORIZATION_GRANT_AUTHENTICATION_KEY = Authentication.class.getName().concat(".AUTHORIZATION_GRANT");
        protected final Map<Object, Object> context = new HashMap<Object, Object>();

        public B registeredClient(RegisteredClient registeredClient) {
            return this.put(RegisteredClient.class, registeredClient);
        }

        public B principal(Authentication principal) {
            return this.put(PRINCIPAL_AUTHENTICATION_KEY, principal);
        }

        public B authorization(OAuth2Authorization authorization) {
            return this.put(OAuth2Authorization.class, authorization);
        }

        public B authorizedScopes(Set<String> authorizedScopes) {
            return this.put(OAuth2Authorization.AUTHORIZED_SCOPE_ATTRIBUTE_NAME, authorizedScopes);
        }

        public B tokenType(OAuth2TokenType tokenType) {
            return this.put(OAuth2TokenType.class, tokenType);
        }

        public B authorizationGrantType(AuthorizationGrantType authorizationGrantType) {
            return this.put(AuthorizationGrantType.class, authorizationGrantType);
        }

        public B authorizationGrant(Authentication authorizationGrant) {
            return this.put(AUTHORIZATION_GRANT_AUTHENTICATION_KEY, authorizationGrant);
        }

        public B put(Object key, Object value) {
            Assert.notNull((Object)key, (String)"key cannot be null");
            Assert.notNull((Object)value, (String)"value cannot be null");
            this.context.put(key, value);
            return this.getThis();
        }

        public B context(Consumer<Map<Object, Object>> contextConsumer) {
            contextConsumer.accept(this.context);
            return this.getThis();
        }

        protected <V> V get(Object key) {
            return (V)this.context.get(key);
        }

        protected B getThis() {
            return (B)this;
        }

        public abstract T build();
    }
}

