/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization;

import java.util.Map;
import java.util.function.Consumer;
import org.springframework.lang.Nullable;
import org.springframework.security.oauth2.core.context.Context;
import org.springframework.security.oauth2.jwt.JoseHeader;
import org.springframework.security.oauth2.jwt.JwtClaimsSet;
import org.springframework.security.oauth2.server.authorization.OAuth2TokenContext;
import org.springframework.util.Assert;

public final class JwtEncodingContext
implements OAuth2TokenContext {
    private final Context context;

    private JwtEncodingContext(Map<Object, Object> context) {
        this.context = Context.of(context);
    }

    @Override
    @Nullable
    public <V> V get(Object key) {
        return this.context.get(key);
    }

    @Override
    public boolean hasKey(Object key) {
        return this.context.hasKey(key);
    }

    public JoseHeader.Builder getHeaders() {
        return this.get(JoseHeader.Builder.class);
    }

    public JwtClaimsSet.Builder getClaims() {
        return this.get(JwtClaimsSet.Builder.class);
    }

    public static Builder with(JoseHeader.Builder headersBuilder, JwtClaimsSet.Builder claimsBuilder) {
        return new Builder(headersBuilder, claimsBuilder);
    }

    public static final class Builder
    extends OAuth2TokenContext.AbstractBuilder<JwtEncodingContext, Builder> {
        private Builder(JoseHeader.Builder headersBuilder, JwtClaimsSet.Builder claimsBuilder) {
            Assert.notNull((Object)headersBuilder, (String)"headersBuilder cannot be null");
            Assert.notNull((Object)claimsBuilder, (String)"claimsBuilder cannot be null");
            this.put(JoseHeader.Builder.class, headersBuilder);
            this.put(JwtClaimsSet.Builder.class, claimsBuilder);
        }

        public Builder headers(Consumer<JoseHeader.Builder> headersConsumer) {
            headersConsumer.accept((JoseHeader.Builder)this.get(JoseHeader.Builder.class));
            return this;
        }

        public Builder claims(Consumer<JwtClaimsSet.Builder> claimsConsumer) {
            claimsConsumer.accept((JwtClaimsSet.Builder)this.get(JwtClaimsSet.Builder.class));
            return this;
        }

        @Override
        public JwtEncodingContext build() {
            return new JwtEncodingContext(this.context);
        }
    }
}

