/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.jwt;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.KeySourceException;
import com.nimbusds.jose.crypto.factories.DefaultJWSSignerFactory;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKMatcher;
import com.nimbusds.jose.jwk.JWKSelector;
import com.nimbusds.jose.jwk.source.JWKSource;
import com.nimbusds.jose.proc.SecurityContext;
import com.nimbusds.jose.produce.JWSSignerFactory;
import com.nimbusds.jose.util.Base64;
import com.nimbusds.jose.util.Base64URL;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.net.URL;
import java.time.Instant;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.oauth2.jwt.JoseHeader;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtClaimsSet;
import org.springframework.security.oauth2.jwt.JwtEncoder;
import org.springframework.security.oauth2.jwt.JwtEncodingException;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public final class NimbusJwsEncoder
implements JwtEncoder {
    private static final String ENCODING_ERROR_MESSAGE_TEMPLATE = "An error occurred while attempting to encode the Jwt: %s";
    private static final Converter<JoseHeader, JWSHeader> JWS_HEADER_CONVERTER = new JwsHeaderConverter();
    private static final Converter<JwtClaimsSet, JWTClaimsSet> JWT_CLAIMS_SET_CONVERTER = new JwtClaimsSetConverter();
    private static final JWSSignerFactory JWS_SIGNER_FACTORY = new DefaultJWSSignerFactory();
    private final Map<JWK, JWSSigner> jwsSigners = new ConcurrentHashMap<JWK, JWSSigner>();
    private final JWKSource<SecurityContext> jwkSource;

    public NimbusJwsEncoder(JWKSource<SecurityContext> jwkSource) {
        Assert.notNull(jwkSource, (String)"jwkSource cannot be null");
        this.jwkSource = jwkSource;
    }

    @Override
    public Jwt encode(JoseHeader headers, JwtClaimsSet claims) throws JwtEncodingException {
        Assert.notNull((Object)headers, (String)"headers cannot be null");
        Assert.notNull((Object)claims, (String)"claims cannot be null");
        JWK jwk = this.selectJwk(headers);
        if (jwk == null) {
            throw new JwtEncodingException(String.format(ENCODING_ERROR_MESSAGE_TEMPLATE, "Failed to select a JWK signing key"));
        }
        if (!StringUtils.hasText((String)jwk.getKeyID())) {
            throw new JwtEncodingException(String.format(ENCODING_ERROR_MESSAGE_TEMPLATE, "The \"kid\" (key ID) from the selected JWK cannot be empty"));
        }
        headers = JoseHeader.from(headers).type(JOSEObjectType.JWT.getType()).keyId(jwk.getKeyID()).build();
        claims = JwtClaimsSet.from(claims).id(UUID.randomUUID().toString()).build();
        JWSHeader jwsHeader = (JWSHeader)JWS_HEADER_CONVERTER.convert((Object)headers);
        JWTClaimsSet jwtClaimsSet = (JWTClaimsSet)JWT_CLAIMS_SET_CONVERTER.convert((Object)claims);
        JWSSigner jwsSigner = this.jwsSigners.computeIfAbsent(jwk, key -> {
            try {
                return JWS_SIGNER_FACTORY.createJWSSigner(key);
            }
            catch (JOSEException ex) {
                throw new JwtEncodingException(String.format(ENCODING_ERROR_MESSAGE_TEMPLATE, "Failed to create a JWS Signer -> " + ex.getMessage()), ex);
            }
        });
        SignedJWT signedJwt = new SignedJWT(jwsHeader, jwtClaimsSet);
        try {
            signedJwt.sign(jwsSigner);
        }
        catch (JOSEException ex) {
            throw new JwtEncodingException(String.format(ENCODING_ERROR_MESSAGE_TEMPLATE, "Failed to sign the JWT -> " + ex.getMessage()), ex);
        }
        String jws = signedJwt.serialize();
        return new Jwt(jws, claims.getIssuedAt(), claims.getExpiresAt(), headers.getHeaders(), claims.getClaims());
    }

    private JWK selectJwk(JoseHeader headers) {
        List jwks;
        JWSAlgorithm jwsAlgorithm = JWSAlgorithm.parse((String)headers.getJwsAlgorithm().getName());
        JWSHeader jwsHeader = new JWSHeader(jwsAlgorithm);
        JWKSelector jwkSelector = new JWKSelector(JWKMatcher.forJWSHeader((JWSHeader)jwsHeader));
        try {
            jwks = this.jwkSource.get(jwkSelector, null);
        }
        catch (KeySourceException ex) {
            throw new JwtEncodingException(String.format(ENCODING_ERROR_MESSAGE_TEMPLATE, "Failed to select a JWK signing key -> " + ex.getMessage()), ex);
        }
        if (jwks.size() > 1) {
            throw new JwtEncodingException(String.format(ENCODING_ERROR_MESSAGE_TEMPLATE, "Found multiple JWK signing keys for algorithm '" + jwsAlgorithm.getName() + "'"));
        }
        return !jwks.isEmpty() ? (JWK)jwks.get(0) : null;
    }

    private static class JwtClaimsSetConverter
    implements Converter<JwtClaimsSet, JWTClaimsSet> {
        private JwtClaimsSetConverter() {
        }

        public JWTClaimsSet convert(JwtClaimsSet claims) {
            Map<String, Object> customClaims;
            String jwtId;
            Instant notBefore;
            Instant expiresAt;
            Instant issuedAt;
            List audience;
            String subject;
            JWTClaimsSet.Builder builder = new JWTClaimsSet.Builder();
            URL issuer = claims.getIssuer();
            if (issuer != null) {
                builder.issuer(issuer.toExternalForm());
            }
            if (StringUtils.hasText((String)(subject = claims.getSubject()))) {
                builder.subject(subject);
            }
            if (!CollectionUtils.isEmpty((Collection)(audience = claims.getAudience()))) {
                builder.audience(audience);
            }
            if ((issuedAt = claims.getIssuedAt()) != null) {
                builder.issueTime(Date.from(issuedAt));
            }
            if ((expiresAt = claims.getExpiresAt()) != null) {
                builder.expirationTime(Date.from(expiresAt));
            }
            if ((notBefore = claims.getNotBefore()) != null) {
                builder.notBeforeTime(Date.from(notBefore));
            }
            if (StringUtils.hasText((String)(jwtId = claims.getId()))) {
                builder.jwtID(jwtId);
            }
            if (!CollectionUtils.isEmpty(customClaims = claims.getClaims().entrySet().stream().filter(claim -> !JWTClaimsSet.getRegisteredNames().contains(claim.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)))) {
                customClaims.forEach((arg_0, arg_1) -> ((JWTClaimsSet.Builder)builder).claim(arg_0, arg_1));
            }
            return builder.build();
        }
    }

    private static class JwsHeaderConverter
    implements Converter<JoseHeader, JWSHeader> {
        private JwsHeaderConverter() {
        }

        public JWSHeader convert(JoseHeader headers) {
            Map<String, Object> customHeaders;
            URL x509Uri;
            String x509SHA256Thumbprint;
            String x509SHA1Thumbprint;
            List<String> x509CertificateChain;
            String type;
            String keyId;
            Map<String, Object> jwk;
            URL jwkSetUri;
            String contentType;
            JWSHeader.Builder builder = new JWSHeader.Builder(JWSAlgorithm.parse((String)headers.getJwsAlgorithm().getName()));
            Set<String> critical = headers.getCritical();
            if (!CollectionUtils.isEmpty(critical)) {
                builder.criticalParams(critical);
            }
            if (StringUtils.hasText((String)(contentType = headers.getContentType()))) {
                builder.contentType(contentType);
            }
            if ((jwkSetUri = headers.getJwkSetUri()) != null) {
                try {
                    builder.jwkURL(jwkSetUri.toURI());
                }
                catch (Exception ex) {
                    throw new JwtEncodingException(String.format(NimbusJwsEncoder.ENCODING_ERROR_MESSAGE_TEMPLATE, "Failed to convert 'jku' JOSE header to a URI"), ex);
                }
            }
            if (!CollectionUtils.isEmpty(jwk = headers.getJwk())) {
                try {
                    builder.jwk(JWK.parse(jwk));
                }
                catch (Exception ex) {
                    throw new JwtEncodingException(String.format(NimbusJwsEncoder.ENCODING_ERROR_MESSAGE_TEMPLATE, "Failed to convert 'jwk' JOSE header"), ex);
                }
            }
            if (StringUtils.hasText((String)(keyId = headers.getKeyId()))) {
                builder.keyID(keyId);
            }
            if (StringUtils.hasText((String)(type = headers.getType()))) {
                builder.type(new JOSEObjectType(type));
            }
            if (!CollectionUtils.isEmpty(x509CertificateChain = headers.getX509CertificateChain())) {
                builder.x509CertChain(x509CertificateChain.stream().map(Base64::new).collect(Collectors.toList()));
            }
            if (StringUtils.hasText((String)(x509SHA1Thumbprint = headers.getX509SHA1Thumbprint()))) {
                builder.x509CertThumbprint(new Base64URL(x509SHA1Thumbprint));
            }
            if (StringUtils.hasText((String)(x509SHA256Thumbprint = headers.getX509SHA256Thumbprint()))) {
                builder.x509CertSHA256Thumbprint(new Base64URL(x509SHA256Thumbprint));
            }
            if ((x509Uri = headers.getX509Uri()) != null) {
                try {
                    builder.x509CertURL(x509Uri.toURI());
                }
                catch (Exception ex) {
                    throw new JwtEncodingException(String.format(NimbusJwsEncoder.ENCODING_ERROR_MESSAGE_TEMPLATE, "Failed to convert 'x5u' JOSE header to a URI"), ex);
                }
            }
            if (!CollectionUtils.isEmpty(customHeaders = headers.getHeaders().entrySet().stream().filter(header -> !JWSHeader.getRegisteredParameterNames().contains(header.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)))) {
                builder.customParams(customHeaders);
            }
            return builder.build();
        }
    }
}

