/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.core.oidc.http.converter;

import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.Converter;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.AbstractHttpMessageConverter;
import org.springframework.http.converter.GenericHttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.security.oauth2.core.converter.ClaimConversionService;
import org.springframework.security.oauth2.core.converter.ClaimTypeConverter;
import org.springframework.security.oauth2.core.oidc.OidcProviderConfiguration;
import org.springframework.security.oauth2.core.oidc.http.converter.HttpMessageConverters;
import org.springframework.util.Assert;

public class OidcProviderConfigurationHttpMessageConverter
extends AbstractHttpMessageConverter<OidcProviderConfiguration> {
    private static final ParameterizedTypeReference<Map<String, Object>> STRING_OBJECT_MAP = new ParameterizedTypeReference<Map<String, Object>>(){};
    private final GenericHttpMessageConverter<Object> jsonMessageConverter = HttpMessageConverters.getJsonMessageConverter();
    private Converter<Map<String, Object>, OidcProviderConfiguration> providerConfigurationConverter = new OidcProviderConfigurationConverter();
    private Converter<OidcProviderConfiguration, Map<String, Object>> providerConfigurationParametersConverter = OidcProviderConfiguration::getClaims;

    public OidcProviderConfigurationHttpMessageConverter() {
        super(new MediaType[]{MediaType.APPLICATION_JSON, new MediaType("application", "*+json")});
    }

    protected boolean supports(Class<?> clazz) {
        return OidcProviderConfiguration.class.isAssignableFrom(clazz);
    }

    protected OidcProviderConfiguration readInternal(Class<? extends OidcProviderConfiguration> clazz, HttpInputMessage inputMessage) throws HttpMessageNotReadableException {
        try {
            Map providerConfigurationParameters = (Map)this.jsonMessageConverter.read(STRING_OBJECT_MAP.getType(), null, inputMessage);
            return (OidcProviderConfiguration)this.providerConfigurationConverter.convert((Object)providerConfigurationParameters);
        }
        catch (Exception ex) {
            throw new HttpMessageNotReadableException("An error occurred reading the OpenID Provider Configuration: " + ex.getMessage(), (Throwable)ex, inputMessage);
        }
    }

    protected void writeInternal(OidcProviderConfiguration providerConfiguration, HttpOutputMessage outputMessage) throws HttpMessageNotWritableException {
        try {
            Map providerConfigurationResponseParameters = (Map)this.providerConfigurationParametersConverter.convert((Object)providerConfiguration);
            this.jsonMessageConverter.write((Object)providerConfigurationResponseParameters, STRING_OBJECT_MAP.getType(), MediaType.APPLICATION_JSON, outputMessage);
        }
        catch (Exception ex) {
            throw new HttpMessageNotWritableException("An error occurred writing the OpenID Provider Configuration: " + ex.getMessage(), (Throwable)ex);
        }
    }

    public final void setProviderConfigurationConverter(Converter<Map<String, Object>, OidcProviderConfiguration> providerConfigurationConverter) {
        Assert.notNull(providerConfigurationConverter, (String)"providerConfigurationConverter cannot be null");
        this.providerConfigurationConverter = providerConfigurationConverter;
    }

    public final void setProviderConfigurationParametersConverter(Converter<OidcProviderConfiguration, Map<String, Object>> providerConfigurationParametersConverter) {
        Assert.notNull(providerConfigurationParametersConverter, (String)"providerConfigurationParametersConverter cannot be null");
        this.providerConfigurationParametersConverter = providerConfigurationParametersConverter;
    }

    private static final class OidcProviderConfigurationConverter
    implements Converter<Map<String, Object>, OidcProviderConfiguration> {
        private static final ClaimConversionService CLAIM_CONVERSION_SERVICE = ClaimConversionService.getSharedInstance();
        private static final TypeDescriptor OBJECT_TYPE_DESCRIPTOR = TypeDescriptor.valueOf(Object.class);
        private static final TypeDescriptor STRING_TYPE_DESCRIPTOR = TypeDescriptor.valueOf(String.class);
        private static final TypeDescriptor URL_TYPE_DESCRIPTOR = TypeDescriptor.valueOf(URL.class);
        private final ClaimTypeConverter claimTypeConverter;

        private OidcProviderConfigurationConverter() {
            Converter<Object, ?> collectionStringConverter = OidcProviderConfigurationConverter.getConverter(TypeDescriptor.collection(Collection.class, (TypeDescriptor)STRING_TYPE_DESCRIPTOR));
            Converter<Object, ?> urlConverter = OidcProviderConfigurationConverter.getConverter(URL_TYPE_DESCRIPTOR);
            HashMap claimConverters = new HashMap();
            claimConverters.put("issuer", urlConverter);
            claimConverters.put("authorization_endpoint", urlConverter);
            claimConverters.put("token_endpoint", urlConverter);
            claimConverters.put("token_endpoint_auth_methods_supported", collectionStringConverter);
            claimConverters.put("jwks_uri", urlConverter);
            claimConverters.put("response_types_supported", collectionStringConverter);
            claimConverters.put("grant_types_supported", collectionStringConverter);
            claimConverters.put("subject_types_supported", collectionStringConverter);
            claimConverters.put("id_token_signing_alg_values_supported", collectionStringConverter);
            claimConverters.put("scopes_supported", collectionStringConverter);
            this.claimTypeConverter = new ClaimTypeConverter(claimConverters);
        }

        public OidcProviderConfiguration convert(Map<String, Object> source) {
            Map parsedClaims = this.claimTypeConverter.convert(source);
            return OidcProviderConfiguration.withClaims(parsedClaims).build();
        }

        private static Converter<Object, ?> getConverter(TypeDescriptor targetDescriptor) {
            return source -> CLAIM_CONVERSION_SERVICE.convert(source, OBJECT_TYPE_DESCRIPTOR, targetDescriptor);
        }
    }
}

