/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.core.oidc;

import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.springframework.security.oauth2.core.Version;
import org.springframework.security.oauth2.core.oidc.OidcProviderMetadataClaimAccessor;
import org.springframework.util.Assert;

public final class OidcProviderConfiguration
implements OidcProviderMetadataClaimAccessor,
Serializable {
    private static final long serialVersionUID = Version.SERIAL_VERSION_UID;
    private final Map<String, Object> claims;

    private OidcProviderConfiguration(Map<String, Object> claims) {
        this.claims = Collections.unmodifiableMap(new LinkedHashMap<String, Object>(claims));
    }

    public Map<String, Object> getClaims() {
        return this.claims;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder withClaims(Map<String, Object> claims) {
        Assert.notEmpty(claims, (String)"claims cannot be empty");
        return new Builder().claims(c -> c.putAll(claims));
    }

    public static class Builder {
        private final Map<String, Object> claims = new LinkedHashMap<String, Object>();

        private Builder() {
        }

        public Builder issuer(String issuer) {
            return this.claim("issuer", issuer);
        }

        public Builder authorizationEndpoint(String authorizationEndpoint) {
            return this.claim("authorization_endpoint", authorizationEndpoint);
        }

        public Builder tokenEndpoint(String tokenEndpoint) {
            return this.claim("token_endpoint", tokenEndpoint);
        }

        public Builder tokenEndpointAuthenticationMethod(String authenticationMethod) {
            this.addClaimToClaimList("token_endpoint_auth_methods_supported", authenticationMethod);
            return this;
        }

        public Builder tokenEndpointAuthenticationMethods(Consumer<List<String>> authenticationMethodsConsumer) {
            this.acceptClaimValues("token_endpoint_auth_methods_supported", authenticationMethodsConsumer);
            return this;
        }

        public Builder jwkSetUri(String jwkSetUri) {
            return this.claim("jwks_uri", jwkSetUri);
        }

        public Builder responseType(String responseType) {
            this.addClaimToClaimList("response_types_supported", responseType);
            return this;
        }

        public Builder responseTypes(Consumer<List<String>> responseTypesConsumer) {
            this.acceptClaimValues("response_types_supported", responseTypesConsumer);
            return this;
        }

        public Builder grantType(String grantType) {
            this.addClaimToClaimList("grant_types_supported", grantType);
            return this;
        }

        public Builder grantTypes(Consumer<List<String>> grantTypesConsumer) {
            this.acceptClaimValues("grant_types_supported", grantTypesConsumer);
            return this;
        }

        public Builder subjectType(String subjectType) {
            this.addClaimToClaimList("subject_types_supported", subjectType);
            return this;
        }

        public Builder subjectTypes(Consumer<List<String>> subjectTypesConsumer) {
            this.acceptClaimValues("subject_types_supported", subjectTypesConsumer);
            return this;
        }

        public Builder scope(String scope) {
            this.addClaimToClaimList("scopes_supported", scope);
            return this;
        }

        public Builder scopes(Consumer<List<String>> scopesConsumer) {
            this.acceptClaimValues("scopes_supported", scopesConsumer);
            return this;
        }

        public Builder idTokenSigningAlgorithm(String signingAlgorithm) {
            this.addClaimToClaimList("id_token_signing_alg_values_supported", signingAlgorithm);
            return this;
        }

        public Builder idTokenSigningAlgorithms(Consumer<List<String>> signingAlgorithmsConsumer) {
            this.acceptClaimValues("id_token_signing_alg_values_supported", signingAlgorithmsConsumer);
            return this;
        }

        public Builder claim(String name, Object value) {
            Assert.hasText((String)name, (String)"name cannot be empty");
            Assert.notNull((Object)value, (String)"value cannot be null");
            this.claims.put(name, value);
            return this;
        }

        public Builder claims(Consumer<Map<String, Object>> claimsConsumer) {
            claimsConsumer.accept(this.claims);
            return this;
        }

        public OidcProviderConfiguration build() {
            this.validateClaims();
            return new OidcProviderConfiguration(this.claims);
        }

        private void validateClaims() {
            Assert.notNull((Object)this.claims.get("issuer"), (String)"issuer cannot be null");
            Builder.validateURL(this.claims.get("issuer"), "issuer must be a valid URL");
            Assert.notNull((Object)this.claims.get("authorization_endpoint"), (String)"authorizationEndpoint cannot be null");
            Builder.validateURL(this.claims.get("authorization_endpoint"), "authorizationEndpoint must be a valid URL");
            Assert.notNull((Object)this.claims.get("token_endpoint"), (String)"tokenEndpoint cannot be null");
            Builder.validateURL(this.claims.get("token_endpoint"), "tokenEndpoint must be a valid URL");
            Assert.notNull((Object)this.claims.get("jwks_uri"), (String)"jwksUri cannot be null");
            Builder.validateURL(this.claims.get("jwks_uri"), "jwksUri must be a valid URL");
            Assert.notNull((Object)this.claims.get("response_types_supported"), (String)"responseTypes cannot be null");
            Assert.isInstanceOf(List.class, (Object)this.claims.get("response_types_supported"), (String)"responseTypes must be of type List");
            Assert.notEmpty((Collection)((List)this.claims.get("response_types_supported")), (String)"responseTypes cannot be empty");
            Assert.notNull((Object)this.claims.get("subject_types_supported"), (String)"subjectTypes cannot be null");
            Assert.isInstanceOf(List.class, (Object)this.claims.get("subject_types_supported"), (String)"subjectTypes must be of type List");
            Assert.notEmpty((Collection)((List)this.claims.get("subject_types_supported")), (String)"subjectTypes cannot be empty");
            Assert.notNull((Object)this.claims.get("id_token_signing_alg_values_supported"), (String)"idTokenSigningAlgorithms cannot be null");
            Assert.isInstanceOf(List.class, (Object)this.claims.get("id_token_signing_alg_values_supported"), (String)"idTokenSigningAlgorithms must be of type List");
            Assert.notEmpty((Collection)((List)this.claims.get("id_token_signing_alg_values_supported")), (String)"idTokenSigningAlgorithms cannot be empty");
        }

        private static void validateURL(Object url, String errorMessage) {
            if (URL.class.isAssignableFrom(url.getClass())) {
                return;
            }
            try {
                new URI(url.toString()).toURL();
            }
            catch (Exception ex) {
                throw new IllegalArgumentException(errorMessage, ex);
            }
        }

        private void addClaimToClaimList(String name, String value) {
            Assert.hasText((String)name, (String)"name cannot be empty");
            Assert.notNull((Object)value, (String)"value cannot be null");
            this.claims.computeIfAbsent(name, k -> new LinkedList());
            ((List)this.claims.get(name)).add(value);
        }

        private void acceptClaimValues(String name, Consumer<List<String>> valuesConsumer) {
            Assert.hasText((String)name, (String)"name cannot be empty");
            Assert.notNull(valuesConsumer, (String)"valuesConsumer cannot be null");
            this.claims.computeIfAbsent(name, k -> new LinkedList());
            List values = (List)this.claims.get(name);
            valuesConsumer.accept(values);
        }
    }
}

