/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.core.context;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.lang.Nullable;
import org.springframework.security.oauth2.core.context.Context;
import org.springframework.util.Assert;

final class DefaultContext
implements Context {
    private final Map<Object, Object> context;

    DefaultContext(Map<Object, Object> context) {
        Assert.notNull(context, (String)"context cannot be null");
        this.context = Collections.unmodifiableMap(new HashMap<Object, Object>(context));
    }

    @Override
    @Nullable
    public <V> V get(Object key) {
        return (V)(this.hasKey(key) ? this.context.get(key) : null);
    }

    @Override
    public boolean hasKey(Object key) {
        Assert.notNull((Object)key, (String)"key cannot be null");
        return this.context.containsKey(key);
    }
}

