/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configurers.oauth2.server.authorization;

import com.nimbusds.jose.jwk.source.JWKSource;
import com.nimbusds.jose.proc.SecurityContext;
import java.net.URI;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.Filter;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.NoUniqueBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.core.ResolvableType;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.ExceptionHandlingConfigurer;
import org.springframework.security.oauth2.jwt.JwtEncoder;
import org.springframework.security.oauth2.jwt.NimbusJwsEncoder;
import org.springframework.security.oauth2.server.authorization.InMemoryOAuth2AuthorizationService;
import org.springframework.security.oauth2.server.authorization.JwtEncodingContext;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationService;
import org.springframework.security.oauth2.server.authorization.OAuth2TokenCustomizer;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2AuthorizationCodeAuthenticationProvider;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2ClientAuthenticationProvider;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2ClientCredentialsAuthenticationProvider;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2RefreshTokenAuthenticationProvider;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2TokenRevocationAuthenticationProvider;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClientRepository;
import org.springframework.security.oauth2.server.authorization.config.ProviderSettings;
import org.springframework.security.oauth2.server.authorization.oidc.web.OidcProviderConfigurationEndpointFilter;
import org.springframework.security.oauth2.server.authorization.web.NimbusJwkSetEndpointFilter;
import org.springframework.security.oauth2.server.authorization.web.OAuth2AuthorizationEndpointFilter;
import org.springframework.security.oauth2.server.authorization.web.OAuth2ClientAuthenticationFilter;
import org.springframework.security.oauth2.server.authorization.web.OAuth2TokenEndpointFilter;
import org.springframework.security.oauth2.server.authorization.web.OAuth2TokenRevocationEndpointFilter;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.access.intercept.FilterSecurityInterceptor;
import org.springframework.security.web.authentication.DelegatingAuthenticationEntryPoint;
import org.springframework.security.web.authentication.HttpStatusEntryPoint;
import org.springframework.security.web.authentication.LoginUrlAuthenticationEntryPoint;
import org.springframework.security.web.authentication.preauth.AbstractPreAuthenticatedProcessingFilter;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.OrRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public final class OAuth2AuthorizationServerConfigurer<B extends HttpSecurityBuilder<B>>
extends AbstractHttpConfigurer<OAuth2AuthorizationServerConfigurer<B>, B> {
    private RequestMatcher authorizationEndpointMatcher;
    private RequestMatcher tokenEndpointMatcher;
    private RequestMatcher tokenRevocationEndpointMatcher;
    private RequestMatcher jwkSetEndpointMatcher;
    private RequestMatcher oidcProviderConfigurationEndpointMatcher;
    private final RequestMatcher endpointsMatcher = request -> this.authorizationEndpointMatcher.matches(request) || this.tokenEndpointMatcher.matches(request) || this.tokenRevocationEndpointMatcher.matches(request) || this.jwkSetEndpointMatcher.matches(request) || this.oidcProviderConfigurationEndpointMatcher.matches(request);

    public OAuth2AuthorizationServerConfigurer<B> registeredClientRepository(RegisteredClientRepository registeredClientRepository) {
        Assert.notNull((Object)registeredClientRepository, (String)"registeredClientRepository cannot be null");
        ((HttpSecurityBuilder)this.getBuilder()).setSharedObject(RegisteredClientRepository.class, (Object)registeredClientRepository);
        return this;
    }

    public OAuth2AuthorizationServerConfigurer<B> authorizationService(OAuth2AuthorizationService authorizationService) {
        Assert.notNull((Object)authorizationService, (String)"authorizationService cannot be null");
        ((HttpSecurityBuilder)this.getBuilder()).setSharedObject(OAuth2AuthorizationService.class, (Object)authorizationService);
        return this;
    }

    public OAuth2AuthorizationServerConfigurer<B> providerSettings(ProviderSettings providerSettings) {
        Assert.notNull((Object)providerSettings, (String)"providerSettings cannot be null");
        ((HttpSecurityBuilder)this.getBuilder()).setSharedObject(ProviderSettings.class, (Object)providerSettings);
        return this;
    }

    public RequestMatcher getEndpointsMatcher() {
        return this.endpointsMatcher;
    }

    public void init(B builder) {
        ProviderSettings providerSettings = OAuth2AuthorizationServerConfigurer.getProviderSettings(builder);
        OAuth2AuthorizationServerConfigurer.validateProviderSettings(providerSettings);
        this.initEndpointMatchers(providerSettings);
        OAuth2ClientAuthenticationProvider clientAuthenticationProvider = new OAuth2ClientAuthenticationProvider(OAuth2AuthorizationServerConfigurer.getRegisteredClientRepository(builder), OAuth2AuthorizationServerConfigurer.getAuthorizationService(builder));
        builder.authenticationProvider((AuthenticationProvider)this.postProcess(clientAuthenticationProvider));
        JwtEncoder jwtEncoder = OAuth2AuthorizationServerConfigurer.getJwtEncoder(builder);
        OAuth2TokenCustomizer<JwtEncodingContext> jwtCustomizer = OAuth2AuthorizationServerConfigurer.getJwtCustomizer(builder);
        OAuth2AuthorizationCodeAuthenticationProvider authorizationCodeAuthenticationProvider = new OAuth2AuthorizationCodeAuthenticationProvider(OAuth2AuthorizationServerConfigurer.getAuthorizationService(builder), jwtEncoder);
        if (jwtCustomizer != null) {
            authorizationCodeAuthenticationProvider.setJwtCustomizer(jwtCustomizer);
        }
        builder.authenticationProvider((AuthenticationProvider)this.postProcess(authorizationCodeAuthenticationProvider));
        OAuth2RefreshTokenAuthenticationProvider refreshTokenAuthenticationProvider = new OAuth2RefreshTokenAuthenticationProvider(OAuth2AuthorizationServerConfigurer.getAuthorizationService(builder), jwtEncoder);
        if (jwtCustomizer != null) {
            refreshTokenAuthenticationProvider.setJwtCustomizer(jwtCustomizer);
        }
        builder.authenticationProvider((AuthenticationProvider)this.postProcess(refreshTokenAuthenticationProvider));
        OAuth2ClientCredentialsAuthenticationProvider clientCredentialsAuthenticationProvider = new OAuth2ClientCredentialsAuthenticationProvider(OAuth2AuthorizationServerConfigurer.getAuthorizationService(builder), jwtEncoder);
        if (jwtCustomizer != null) {
            clientCredentialsAuthenticationProvider.setJwtCustomizer(jwtCustomizer);
        }
        builder.authenticationProvider((AuthenticationProvider)this.postProcess(clientCredentialsAuthenticationProvider));
        OAuth2TokenRevocationAuthenticationProvider tokenRevocationAuthenticationProvider = new OAuth2TokenRevocationAuthenticationProvider(OAuth2AuthorizationServerConfigurer.getAuthorizationService(builder));
        builder.authenticationProvider((AuthenticationProvider)this.postProcess(tokenRevocationAuthenticationProvider));
        ExceptionHandlingConfigurer exceptionHandling = (ExceptionHandlingConfigurer)builder.getConfigurer(ExceptionHandlingConfigurer.class);
        if (exceptionHandling != null) {
            LinkedHashMap<OrRequestMatcher, HttpStatusEntryPoint> entryPoints = new LinkedHashMap<OrRequestMatcher, HttpStatusEntryPoint>();
            entryPoints.put(new OrRequestMatcher(new RequestMatcher[]{this.tokenEndpointMatcher, this.tokenRevocationEndpointMatcher}), new HttpStatusEntryPoint(HttpStatus.UNAUTHORIZED));
            DelegatingAuthenticationEntryPoint authenticationEntryPoint = new DelegatingAuthenticationEntryPoint(entryPoints);
            authenticationEntryPoint.setDefaultEntryPoint((AuthenticationEntryPoint)new LoginUrlAuthenticationEntryPoint("/login"));
            exceptionHandling.authenticationEntryPoint((AuthenticationEntryPoint)authenticationEntryPoint);
        }
    }

    public void configure(B builder) {
        ProviderSettings providerSettings = OAuth2AuthorizationServerConfigurer.getProviderSettings(builder);
        if (providerSettings.issuer() != null) {
            OidcProviderConfigurationEndpointFilter oidcProviderConfigurationEndpointFilter = new OidcProviderConfigurationEndpointFilter(providerSettings);
            builder.addFilterBefore((Filter)this.postProcess((Object)oidcProviderConfigurationEndpointFilter), AbstractPreAuthenticatedProcessingFilter.class);
        }
        JWKSource<SecurityContext> jwkSource = OAuth2AuthorizationServerConfigurer.getJwkSource(builder);
        NimbusJwkSetEndpointFilter jwkSetEndpointFilter = new NimbusJwkSetEndpointFilter(jwkSource, providerSettings.jwkSetEndpoint());
        builder.addFilterBefore((Filter)this.postProcess((Object)jwkSetEndpointFilter), AbstractPreAuthenticatedProcessingFilter.class);
        AuthenticationManager authenticationManager = (AuthenticationManager)builder.getSharedObject(AuthenticationManager.class);
        OAuth2ClientAuthenticationFilter clientAuthenticationFilter = new OAuth2ClientAuthenticationFilter(authenticationManager, (RequestMatcher)new OrRequestMatcher(new RequestMatcher[]{this.tokenEndpointMatcher, this.tokenRevocationEndpointMatcher}));
        builder.addFilterAfter((Filter)this.postProcess((Object)clientAuthenticationFilter), AbstractPreAuthenticatedProcessingFilter.class);
        OAuth2AuthorizationEndpointFilter authorizationEndpointFilter = new OAuth2AuthorizationEndpointFilter(OAuth2AuthorizationServerConfigurer.getRegisteredClientRepository(builder), OAuth2AuthorizationServerConfigurer.getAuthorizationService(builder), providerSettings.authorizationEndpoint());
        builder.addFilterBefore((Filter)this.postProcess((Object)authorizationEndpointFilter), AbstractPreAuthenticatedProcessingFilter.class);
        OAuth2TokenEndpointFilter tokenEndpointFilter = new OAuth2TokenEndpointFilter(authenticationManager, providerSettings.tokenEndpoint());
        builder.addFilterAfter((Filter)this.postProcess((Object)tokenEndpointFilter), FilterSecurityInterceptor.class);
        OAuth2TokenRevocationEndpointFilter tokenRevocationEndpointFilter = new OAuth2TokenRevocationEndpointFilter(authenticationManager, providerSettings.tokenRevocationEndpoint());
        builder.addFilterAfter((Filter)this.postProcess((Object)tokenRevocationEndpointFilter), OAuth2TokenEndpointFilter.class);
    }

    private void initEndpointMatchers(ProviderSettings providerSettings) {
        this.authorizationEndpointMatcher = new OrRequestMatcher(new RequestMatcher[]{new AntPathRequestMatcher(providerSettings.authorizationEndpoint(), HttpMethod.GET.name()), new AntPathRequestMatcher(providerSettings.authorizationEndpoint(), HttpMethod.POST.name())});
        this.tokenEndpointMatcher = new AntPathRequestMatcher(providerSettings.tokenEndpoint(), HttpMethod.POST.name());
        this.tokenRevocationEndpointMatcher = new AntPathRequestMatcher(providerSettings.tokenRevocationEndpoint(), HttpMethod.POST.name());
        this.jwkSetEndpointMatcher = new AntPathRequestMatcher(providerSettings.jwkSetEndpoint(), HttpMethod.GET.name());
        this.oidcProviderConfigurationEndpointMatcher = new AntPathRequestMatcher("/.well-known/openid-configuration", HttpMethod.GET.name());
    }

    private static void validateProviderSettings(ProviderSettings providerSettings) {
        if (providerSettings.issuer() != null) {
            try {
                new URI(providerSettings.issuer()).toURL();
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("issuer must be a valid URL", ex);
            }
        }
    }

    private static <B extends HttpSecurityBuilder<B>> RegisteredClientRepository getRegisteredClientRepository(B builder) {
        RegisteredClientRepository registeredClientRepository = (RegisteredClientRepository)builder.getSharedObject(RegisteredClientRepository.class);
        if (registeredClientRepository == null) {
            registeredClientRepository = OAuth2AuthorizationServerConfigurer.getBean(builder, RegisteredClientRepository.class);
            builder.setSharedObject(RegisteredClientRepository.class, (Object)registeredClientRepository);
        }
        return registeredClientRepository;
    }

    private static <B extends HttpSecurityBuilder<B>> OAuth2AuthorizationService getAuthorizationService(B builder) {
        OAuth2AuthorizationService authorizationService = (OAuth2AuthorizationService)builder.getSharedObject(OAuth2AuthorizationService.class);
        if (authorizationService == null) {
            authorizationService = OAuth2AuthorizationServerConfigurer.getOptionalBean(builder, OAuth2AuthorizationService.class);
            if (authorizationService == null) {
                authorizationService = new InMemoryOAuth2AuthorizationService();
            }
            builder.setSharedObject(OAuth2AuthorizationService.class, (Object)authorizationService);
        }
        return authorizationService;
    }

    private static <B extends HttpSecurityBuilder<B>> JwtEncoder getJwtEncoder(B builder) {
        JwtEncoder jwtEncoder = (JwtEncoder)builder.getSharedObject(JwtEncoder.class);
        if (jwtEncoder == null) {
            jwtEncoder = OAuth2AuthorizationServerConfigurer.getOptionalBean(builder, JwtEncoder.class);
            if (jwtEncoder == null) {
                JWKSource<SecurityContext> jwkSource = OAuth2AuthorizationServerConfigurer.getJwkSource(builder);
                jwtEncoder = new NimbusJwsEncoder(jwkSource);
            }
            builder.setSharedObject(JwtEncoder.class, (Object)jwtEncoder);
        }
        return jwtEncoder;
    }

    private static <B extends HttpSecurityBuilder<B>> JWKSource<SecurityContext> getJwkSource(B builder) {
        JWKSource jwkSource = (JWKSource)builder.getSharedObject(JWKSource.class);
        if (jwkSource == null) {
            ResolvableType type = ResolvableType.forClassWithGenerics(JWKSource.class, (Class[])new Class[]{SecurityContext.class});
            jwkSource = (JWKSource)OAuth2AuthorizationServerConfigurer.getBean(builder, type);
            builder.setSharedObject(JWKSource.class, (Object)jwkSource);
        }
        return jwkSource;
    }

    private static <B extends HttpSecurityBuilder<B>> OAuth2TokenCustomizer<JwtEncodingContext> getJwtCustomizer(B builder) {
        ResolvableType type;
        OAuth2TokenCustomizer jwtCustomizer = (OAuth2TokenCustomizer)builder.getSharedObject(OAuth2TokenCustomizer.class);
        if (jwtCustomizer == null && (jwtCustomizer = (OAuth2TokenCustomizer)OAuth2AuthorizationServerConfigurer.getOptionalBean(builder, type = ResolvableType.forClassWithGenerics(OAuth2TokenCustomizer.class, (Class[])new Class[]{JwtEncodingContext.class}))) != null) {
            builder.setSharedObject(OAuth2TokenCustomizer.class, (Object)jwtCustomizer);
        }
        return jwtCustomizer;
    }

    private static <B extends HttpSecurityBuilder<B>> ProviderSettings getProviderSettings(B builder) {
        ProviderSettings providerSettings = (ProviderSettings)builder.getSharedObject(ProviderSettings.class);
        if (providerSettings == null) {
            providerSettings = OAuth2AuthorizationServerConfigurer.getOptionalBean(builder, ProviderSettings.class);
            if (providerSettings == null) {
                providerSettings = new ProviderSettings();
            }
            builder.setSharedObject(ProviderSettings.class, (Object)providerSettings);
        }
        return providerSettings;
    }

    private static <B extends HttpSecurityBuilder<B>, T> T getBean(B builder, Class<T> type) {
        return (T)((ApplicationContext)builder.getSharedObject(ApplicationContext.class)).getBean(type);
    }

    private static <B extends HttpSecurityBuilder<B>, T> T getBean(B builder, ResolvableType type) {
        ApplicationContext context = (ApplicationContext)builder.getSharedObject(ApplicationContext.class);
        String[] names = context.getBeanNamesForType(type);
        if (names.length == 1) {
            return (T)context.getBean(names[0]);
        }
        if (names.length > 1) {
            throw new NoUniqueBeanDefinitionException(type, names);
        }
        throw new NoSuchBeanDefinitionException(type);
    }

    private static <B extends HttpSecurityBuilder<B>, T> T getOptionalBean(B builder, Class<T> type) {
        Map beansMap = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)((ListableBeanFactory)builder.getSharedObject(ApplicationContext.class)), type);
        if (beansMap.size() > 1) {
            throw new NoUniqueBeanDefinitionException(type, beansMap.size(), "Expected single matching bean of type '" + type.getName() + "' but found " + beansMap.size() + ": " + StringUtils.collectionToCommaDelimitedString(beansMap.keySet()));
        }
        return !beansMap.isEmpty() ? (T)beansMap.values().iterator().next() : null;
    }

    private static <B extends HttpSecurityBuilder<B>, T> T getOptionalBean(B builder, ResolvableType type) {
        ApplicationContext context = (ApplicationContext)builder.getSharedObject(ApplicationContext.class);
        String[] names = context.getBeanNamesForType(type);
        if (names.length > 1) {
            throw new NoUniqueBeanDefinitionException(type, names);
        }
        return (T)(names.length == 1 ? context.getBean(names[0]) : null);
    }
}

