/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file.config;

import org.springframework.beans.BeanMetadataElement;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.xml.AbstractPollingInboundChannelAdapterParser;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.integration.core.MessageSource;
import org.springframework.integration.file.config.FileParserUtils;
import org.springframework.integration.file.filters.FileListFilter;
import org.springframework.integration.file.remote.RemoteFileOperations;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public abstract class AbstractRemoteFileStreamingInboundChannelAdapterParser
extends AbstractPollingInboundChannelAdapterParser {
    protected final BeanMetadataElement parseSource(Element element, ParserContext parserContext) {
        BeanDefinition templateDefinition = FileParserUtils.parseRemoteFileTemplate(element, parserContext, false, this.getTemplateClass());
        BeanDefinitionBuilder messageSourceBuilder = BeanDefinitionBuilder.genericBeanDefinition(this.getMessageSourceClass());
        messageSourceBuilder.addConstructorArgValue((Object)templateDefinition);
        BeanDefinition expressionDef = IntegrationNamespaceUtils.createExpressionDefinitionFromValueOrExpression((String)"remote-directory", (String)"remote-directory-expression", (ParserContext)parserContext, (Element)element, (boolean)false);
        if (expressionDef != null) {
            messageSourceBuilder.addPropertyValue("remoteDirectoryExpression", (Object)expressionDef);
        }
        String remoteFileSeparator = element.getAttribute("remote-file-separator");
        messageSourceBuilder.addPropertyValue("remoteFileSeparator", (Object)remoteFileSeparator);
        FileParserUtils.configureFilter(messageSourceBuilder, element, parserContext, this.getSimplePatternFileListFilterClass(), this.getRegexPatternFileListFilterClass());
        String comparator = element.getAttribute("comparator");
        if (StringUtils.hasText((String)comparator)) {
            messageSourceBuilder.addConstructorArgReference(comparator);
        }
        return messageSourceBuilder.getBeanDefinition();
    }

    protected abstract Class<? extends RemoteFileOperations<?>> getTemplateClass();

    protected abstract Class<? extends MessageSource<?>> getMessageSourceClass();

    protected abstract Class<? extends FileListFilter<?>> getSimplePatternFileListFilterClass();

    protected abstract Class<? extends FileListFilter<?>> getRegexPatternFileListFilterClass();
}

