/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.brave.instrument.messaging;

import brave.jms.JmsTracing;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSContext;
import javax.jms.JMSException;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.sleuth.brave.instrument.messaging.LazyConnectionFactory;

class LazyTopicConnectionFactory
implements TopicConnectionFactory {
    private final BeanFactory beanFactory;
    private final TopicConnectionFactory delegate;
    private final LazyConnectionFactory factory;
    private JmsTracing jmsTracing;

    LazyTopicConnectionFactory(BeanFactory beanFactory, TopicConnectionFactory delegate) {
        this.beanFactory = beanFactory;
        this.delegate = delegate;
        this.factory = new LazyConnectionFactory(beanFactory, (ConnectionFactory)delegate);
    }

    public TopicConnection createTopicConnection() throws JMSException {
        return this.jmsTracing().topicConnection(this.delegate.createTopicConnection());
    }

    public TopicConnection createTopicConnection(String s, String s1) throws JMSException {
        return this.jmsTracing().topicConnection(this.delegate.createTopicConnection(s, s1));
    }

    public Connection createConnection() throws JMSException {
        return this.factory.createConnection();
    }

    public Connection createConnection(String s, String s1) throws JMSException {
        return this.factory.createConnection(s, s1);
    }

    public JMSContext createContext() {
        return this.factory.createContext();
    }

    public JMSContext createContext(String s, String s1) {
        return this.factory.createContext(s, s1);
    }

    public JMSContext createContext(String s, String s1, int i) {
        return this.factory.createContext(s, s1, i);
    }

    public JMSContext createContext(int i) {
        return this.factory.createContext(i);
    }

    private JmsTracing jmsTracing() {
        if (this.jmsTracing != null) {
            return this.jmsTracing;
        }
        this.jmsTracing = (JmsTracing)this.beanFactory.getBean(JmsTracing.class);
        return this.jmsTracing;
    }
}

