/*
 * Decompiled with CFR 0.152.
 */
package spock.mock;

import java.util.Collections;
import java.util.Map;
import org.spockframework.mock.MockImplementation;
import org.spockframework.mock.MockNature;
import org.spockframework.mock.MockUtil;
import spock.mock.MockFactory;

public class DetachedMockFactory
implements MockFactory {
    @Override
    public <T> T Mock(Class<T> type) {
        return (T)this.createMock(this.inferNameFromType(type), (T)type, MockNature.MOCK, Collections.<String, Object>emptyMap());
    }

    @Override
    public <T> T Mock(Map<String, Object> options, Class<T> type) {
        return (T)this.createMock(this.inferNameFromType(type), (T)type, MockNature.MOCK, options);
    }

    @Override
    public <T> T Stub(Class<T> type) {
        return (T)this.createMock(this.inferNameFromType(type), (T)type, MockNature.STUB, Collections.<String, Object>emptyMap());
    }

    @Override
    public <T> T Stub(Map<String, Object> options, Class<T> type) {
        return (T)this.createMock(this.inferNameFromType(type), (T)type, MockNature.STUB, options);
    }

    @Override
    public <T> T Spy(Class<T> type) {
        return (T)this.createMock(this.inferNameFromType(type), (T)type, MockNature.SPY, Collections.<String, Object>emptyMap());
    }

    @Override
    public <T> T Spy(T obj) {
        return this.createMock(this.inferNameFromType(obj.getClass()), obj, MockNature.SPY, Collections.<String, Object>emptyMap());
    }

    @Override
    public <T> T Spy(Map<String, Object> options, Class<T> type) {
        return (T)this.createMock(this.inferNameFromType(type), (T)type, MockNature.SPY, options);
    }

    public <T> T createMock(String name, Class<T> type, MockNature nature, Map<String, Object> options) {
        ClassLoader classLoader = type.getClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        return (T)new MockUtil().createDetachedMock(name, type, nature, MockImplementation.JAVA, options, classLoader);
    }

    public <T> T createMock(String name, T obj, MockNature nature, Map<String, Object> options) {
        ClassLoader classLoader = obj.getClass().getClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        return (T)new MockUtil().createDetachedMock(name, obj, nature, MockImplementation.JAVA, options, classLoader);
    }

    private String inferNameFromType(Class<?> type) {
        return type.getSimpleName();
    }
}

