/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime;

import groovy.lang.GString;
import org.spockframework.runtime.GroovyRuntimeUtil;
import org.spockframework.runtime.condition.EditDistance;
import org.spockframework.runtime.condition.EditPathRenderer;
import org.spockframework.runtime.model.ExpressionInfo;
import org.spockframework.util.ObjectUtil;

public class ExpressionInfoValueRenderer {
    public static final long MAX_EDIT_DISTANCE_MEMORY = 51200L;
    private final ExpressionInfo expr;

    private ExpressionInfoValueRenderer(ExpressionInfo expr) {
        this.expr = expr;
    }

    public static void render(ExpressionInfo expr) {
        new ExpressionInfoValueRenderer(expr).render();
    }

    private void render() {
        for (ExpressionInfo expr : this.expr.inPostfixOrder(true)) {
            expr.setRenderedValue(this.renderValue(expr));
        }
    }

    private String renderValue(ExpressionInfo expr) {
        int index;
        String text;
        String potentialEnumConstantNameInText;
        String str;
        Object value = expr.getValue();
        if (value == null) {
            return "null";
        }
        if ("".equals(value)) {
            return "\"\"";
        }
        try {
            str = this.doRenderValue(expr);
        }
        catch (Exception e) {
            return String.format("%s (renderer threw %s)", this.javaLangObjectToString(value), e.getClass().getSimpleName());
        }
        if (str == null || str.equals("")) {
            return this.javaLangObjectToString(value);
        }
        if (value instanceof Enum && str.equals(potentialEnumConstantNameInText = (text = expr.getText().trim()).substring((index = text.lastIndexOf(46)) + 1))) {
            return null;
        }
        return str;
    }

    private String javaLangObjectToString(Object value) {
        String hash = Integer.toHexString(System.identityHashCode(value));
        return value.getClass().getName() + "@" + hash;
    }

    private String doRenderValue(ExpressionInfo expr) {
        String result = this.renderAsFailedStringComparison(expr);
        if (result != null) {
            return result;
        }
        result = this.renderAsFailedEqualityComparison(expr);
        if (result != null) {
            return result;
        }
        return GroovyRuntimeUtil.toString(expr.getValue());
    }

    private String renderAsFailedStringComparison(ExpressionInfo expr) {
        if (!Boolean.FALSE.equals(expr.getValue())) {
            return null;
        }
        if (!expr.isEqualityComparison(String.class, GString.class)) {
            return null;
        }
        String str1 = expr.getChildren().get(0).getValue().toString();
        String str2 = expr.getChildren().get(1).getValue().toString();
        if ((long)str1.length() * (long)str2.length() > 51200L) {
            return this.tryReduceStringSizes(str1, str2);
        }
        return this.createAndRenderEditDistance(str1, str2);
    }

    private String tryReduceStringSizes(String str1, String str2) {
        int end2;
        int minLength;
        int commonStart = minLength = Math.min(str1.length(), str2.length());
        for (int i = 0; i < minLength; ++i) {
            if (str1.charAt(i) == str2.charAt(i)) continue;
            commonStart = i - 1;
            break;
        }
        commonStart = Math.max(0, commonStart);
        int end1 = str1.length() - 1;
        for (end2 = str2.length() - 1; end1 >= 0 && end2 >= 0 && str1.charAt(end1) == str2.charAt(end2); --end1, --end2) {
        }
        if ((long)((++end1 - commonStart) * (++end2 - commonStart)) > 51200L) {
            return "false\nStrings too large to calculate edit distance.";
        }
        if ((long)((end1 - commonStart + 20) * (end2 - commonStart + 20)) < 51200L) {
            commonStart = Math.max(0, commonStart - 10);
            end1 = Math.min(str1.length(), end1 + 10);
            end2 = Math.min(str2.length(), end2 + 10);
        }
        return this.createAndRenderEditDistance(str1, str2, commonStart, end1, end2);
    }

    private String createAndRenderEditDistance(String str1, String str2) {
        EditDistance dist = new EditDistance(str1, str2);
        return String.format("false\n%d difference%s (%d%% similarity)\n%s", dist.getDistance(), dist.getDistance() == 1 ? "" : "s", dist.getSimilarityInPercent(), new EditPathRenderer().render(str1, str2, dist.calculatePath()));
    }

    private String createAndRenderEditDistance(String str1, String str2, int commonStart, int end1, int end2) {
        String sub1 = str1.substring(commonStart, end1);
        String sub2 = str2.substring(commonStart, end2);
        EditDistance dist = new EditDistance(sub1, sub2);
        return String.format("false\n%d difference%s (%d%% similarity) (comparing subset start: %d, end1: %d, end2: %d)\n%s", dist.getDistance(), dist.getDistance() == 1 ? "" : "s", dist.getSimilarityInPercent(), commonStart, end1, end2, new EditPathRenderer().render(sub1, sub2, dist.calculatePath()));
    }

    private String renderAsFailedEqualityComparison(ExpressionInfo expr) {
        if (!Boolean.FALSE.equals(expr.getValue())) {
            return null;
        }
        if (!expr.isEqualityComparison()) {
            return null;
        }
        ExpressionInfo expr1 = expr.getChildren().get(0);
        ExpressionInfo expr2 = expr.getChildren().get(1);
        if (expr1.getEffectiveRenderedValue().equals(expr2.getEffectiveRenderedValue())) {
            this.addTypeHint(expr1);
            this.addTypeHint(expr2);
        }
        return "false";
    }

    private void addTypeHint(ExpressionInfo expr) {
        if (expr.getRenderedValue() == null) {
            return;
        }
        Class<?> exprType = ObjectUtil.voidAwareGetClass(expr.getValue());
        expr.setRenderedValue(expr.getRenderedValue() + " (" + exprType.getName() + ")");
    }
}

