/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime;

import java.util.List;
import java.util.regex.Pattern;
import org.spockframework.runtime.ExpressionInfoBuilder;
import org.spockframework.runtime.ExpressionInfoRenderer;
import org.spockframework.runtime.ExpressionInfoValueRenderer;
import org.spockframework.runtime.model.ExpressionInfo;
import org.spockframework.runtime.model.TextPosition;

public class Condition {
    private static final Pattern pattern = Pattern.compile("\\s*\n\\s*");
    private final List<Object> values;
    private final String text;
    private final TextPosition position;
    private final String message;
    private final Integer notRecordedVarNumberBecauseOfException;
    private final Throwable exception;
    private volatile ExpressionInfo expression;
    private volatile String rendering;

    public Condition(List<Object> values, String text, TextPosition position, String message, Integer notRecordedVarNumberBecauseOfException, Throwable exception) {
        this.text = text;
        this.position = position;
        this.values = values;
        this.message = message;
        this.notRecordedVarNumberBecauseOfException = notRecordedVarNumberBecauseOfException;
        this.exception = exception;
    }

    public List<Object> getValues() {
        return this.values;
    }

    public String getText() {
        return this.text;
    }

    public TextPosition getPosition() {
        return this.position;
    }

    public String getMessage() {
        return this.message;
    }

    public ExpressionInfo getExpression() {
        if (this.expression == null) {
            this.createExpression();
        }
        return this.expression;
    }

    public String getRendering() {
        if (this.rendering == null) {
            this.createRendering();
        }
        return this.rendering;
    }

    private void createExpression() {
        if (this.text == null || this.values == null) {
            return;
        }
        this.expression = new ExpressionInfoBuilder(this.flatten(this.text), TextPosition.create(1, 1), this.values, this.notRecordedVarNumberBecauseOfException, this.exception).build();
    }

    private void createRendering() {
        StringBuilder builder = new StringBuilder();
        if (this.getExpression() != null) {
            ExpressionInfoValueRenderer.render(this.expression);
            builder.append(ExpressionInfoRenderer.render(this.expression));
        } else if (this.text != null) {
            builder.append(this.flatten(this.text));
            builder.append("\n");
        } else {
            builder.append("(Source code not available)\n");
        }
        if (this.message != null) {
            builder.append("\n");
            builder.append(this.message);
            builder.append("\n");
        }
        this.rendering = builder.toString();
    }

    private String flatten(String text) {
        return pattern.matcher(text).replaceAll(" ");
    }
}

