/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime;

import java.lang.annotation.Annotation;
import org.junit.runner.Description;
import org.spockframework.runtime.IRunSupervisor;
import org.spockframework.runtime.RunStatus;
import org.spockframework.runtime.SafeIterationNameProvider;
import org.spockframework.runtime.SpecificationContext;
import org.spockframework.runtime.extension.IMethodInterceptor;
import org.spockframework.runtime.extension.MethodInvocation;
import org.spockframework.runtime.model.ErrorInfo;
import org.spockframework.runtime.model.FeatureInfo;
import org.spockframework.runtime.model.IterationInfo;
import org.spockframework.runtime.model.MethodInfo;
import org.spockframework.runtime.model.MethodKind;
import org.spockframework.runtime.model.SpecInfo;
import org.spockframework.util.CollectionUtil;
import org.spockframework.util.InternalSpockError;
import spock.lang.Specification;

public class BaseSpecRunner {
    protected static final Object[] EMPTY_ARGS = new Object[0];
    protected final SpecInfo spec;
    protected final IRunSupervisor supervisor;
    protected FeatureInfo currentFeature;
    protected IterationInfo currentIteration;
    protected Specification sharedInstance;
    protected Specification currentInstance;
    protected int runStatus = 0;

    public BaseSpecRunner(SpecInfo spec, IRunSupervisor supervisor) {
        this.spec = spec;
        this.supervisor = supervisor;
    }

    public int run() {
        if (this.spec.isExcluded() || this.spec.isSkipped()) {
            this.supervisor.specSkipped(this.spec);
            return 0;
        }
        this.createSpecInstance(true);
        this.runSharedInitializer();
        this.runSpec();
        return this.resetStatus(16);
    }

    private void runSpec() {
        if (this.runStatus != 0) {
            return;
        }
        this.supervisor.beforeSpec(this.spec);
        this.invoke(this, this.createMethodInfoForDoRunSpec(), new Object[0]);
        this.supervisor.afterSpec(this.spec);
    }

    private MethodInfo createMethodInfoForDoRunSpec() {
        MethodInfo result = new MethodInfo(){

            @Override
            public Object invoke(Object target, Object ... arguments) {
                BaseSpecRunner.this.doRunSpec();
                return null;
            }
        };
        result.setParent(this.spec);
        result.setKind(MethodKind.SPEC_EXECUTION);
        result.setDescription(this.spec.getDescription());
        for (IMethodInterceptor interceptor : this.spec.getInterceptors()) {
            result.addInterceptor(interceptor);
        }
        return result;
    }

    public void doRunSpec() {
        this.runSetupSpec();
        this.runFeatures();
        this.runCleanupSpec();
    }

    private void createSpecInstance(boolean shared) {
        if (this.runStatus != 0) {
            return;
        }
        try {
            this.currentInstance = shared ? (this.sharedInstance = (Specification)((Class)this.spec.getReflection()).newInstance()) : (Specification)((Class)this.spec.getReflection()).newInstance();
        }
        catch (Throwable t) {
            throw new InternalSpockError("Failed to instantiate spec '%s'", t).withArgs(this.spec.getName());
        }
        this.getSpecificationContext().setCurrentSpec(this.spec);
        this.getSpecificationContext().setSharedInstance(this.sharedInstance);
    }

    private void runSharedInitializer() {
        this.runSharedInitializer(this.spec);
    }

    private void runSharedInitializer(SpecInfo spec) {
        if (spec == null) {
            return;
        }
        this.invoke(this, this.createMethodInfoForDoRunSharedInitializer(spec), spec);
    }

    private MethodInfo createMethodInfoForDoRunSharedInitializer(final SpecInfo spec) {
        MethodInfo result = new MethodInfo(){

            @Override
            public Object invoke(Object target, Object ... arguments) {
                BaseSpecRunner.this.doRunSharedInitializer(spec);
                return null;
            }
        };
        result.setParent(spec);
        result.setKind(MethodKind.SHARED_INITIALIZER);
        result.setDescription(spec.getDescription());
        for (IMethodInterceptor interceptor : spec.getSharedInitializerInterceptors()) {
            result.addInterceptor(interceptor);
        }
        return result;
    }

    public void doRunSharedInitializer(SpecInfo spec) {
        this.runSharedInitializer(spec.getSuperSpec());
        if (this.runStatus != 0) {
            return;
        }
        this.invoke(this.currentInstance, spec.getSharedInitializerMethod(), new Object[0]);
    }

    private void runSetupSpec() {
        this.runSetupSpec(this.spec);
    }

    private void runSetupSpec(SpecInfo spec) {
        if (spec == null) {
            return;
        }
        this.invoke(this, this.createMethodInfoForDoRunSetupSpec(spec), spec);
    }

    private MethodInfo createMethodInfoForDoRunSetupSpec(final SpecInfo spec) {
        MethodInfo result = new MethodInfo(){

            @Override
            public Object invoke(Object target, Object ... arguments) {
                BaseSpecRunner.this.doRunSetupSpec(spec);
                return null;
            }
        };
        result.setParent(spec);
        result.setKind(MethodKind.SETUP_SPEC);
        result.setDescription(spec.getDescription());
        for (IMethodInterceptor interceptor : spec.getSetupSpecInterceptors()) {
            result.addInterceptor(interceptor);
        }
        return result;
    }

    public void doRunSetupSpec(SpecInfo spec) {
        this.runSetupSpec(spec.getSuperSpec());
        for (MethodInfo method : spec.getSetupSpecMethods()) {
            if (this.runStatus != 0) {
                return;
            }
            this.invoke(this.currentInstance, method, new Object[0]);
        }
    }

    private void runFeatures() {
        for (FeatureInfo feature : this.spec.getAllFeaturesInExecutionOrder()) {
            if (this.resetStatus(8) != 0) {
                return;
            }
            this.currentFeature = feature;
            this.runFeature();
            this.currentFeature = null;
        }
    }

    private void runCleanupSpec() {
        this.currentInstance = this.sharedInstance;
        this.runCleanupSpec(this.spec);
    }

    private void runCleanupSpec(SpecInfo spec) {
        if (spec == null) {
            return;
        }
        this.invoke(this, this.createMethodForDoRunCleanupSpec(spec), spec);
    }

    private MethodInfo createMethodForDoRunCleanupSpec(final SpecInfo spec) {
        MethodInfo result = new MethodInfo(){

            @Override
            public Object invoke(Object target, Object ... arguments) {
                BaseSpecRunner.this.doRunCleanupSpec(spec);
                return null;
            }
        };
        result.setParent(spec);
        result.setKind(MethodKind.CLEANUP_SPEC);
        result.setDescription(spec.getDescription());
        for (IMethodInterceptor interceptor : spec.getCleanupSpecInterceptors()) {
            result.addInterceptor(interceptor);
        }
        return result;
    }

    public void doRunCleanupSpec(SpecInfo spec) {
        for (MethodInfo method : spec.getCleanupSpecMethods()) {
            if (RunStatus.action(this.runStatus) == 2) {
                return;
            }
            this.invoke(this.currentInstance, method, new Object[0]);
        }
        this.runCleanupSpec(spec.getSuperSpec());
    }

    private void runFeature() {
        if (this.runStatus != 0) {
            return;
        }
        if (this.currentFeature.isExcluded()) {
            return;
        }
        if (this.currentFeature.isSkipped()) {
            this.supervisor.featureSkipped(this.currentFeature);
            return;
        }
        this.supervisor.beforeFeature(this.currentFeature);
        this.invoke(this, this.createMethodInfoForDoRunFeature(), new Object[0]);
        this.supervisor.afterFeature(this.currentFeature);
    }

    private MethodInfo createMethodInfoForDoRunFeature() {
        MethodInfo result = new MethodInfo(){

            @Override
            public Object invoke(Object target, Object ... arguments) {
                BaseSpecRunner.this.doRunFeature();
                return null;
            }
        };
        result.setParent(this.currentFeature.getParent());
        result.setKind(MethodKind.FEATURE_EXECUTION);
        result.setFeature(this.currentFeature);
        result.setDescription(this.currentFeature.getDescription());
        for (IMethodInterceptor interceptor : this.currentFeature.getInterceptors()) {
            result.addInterceptor(interceptor);
        }
        return result;
    }

    public void doRunFeature() {
        this.currentFeature.setIterationNameProvider(new SafeIterationNameProvider(this.currentFeature.getIterationNameProvider()));
        if (this.currentFeature.isParameterized()) {
            this.runParameterizedFeature();
        } else {
            this.runSimpleFeature();
        }
    }

    private void runSimpleFeature() {
        if (this.runStatus != 0) {
            return;
        }
        this.initializeAndRunIteration(EMPTY_ARGS, 1);
        this.resetStatus(4);
    }

    protected void initializeAndRunIteration(Object[] dataValues, int estimatedNumIterations) {
        if (this.runStatus != 0) {
            return;
        }
        this.createSpecInstance(false);
        this.runInitializer();
        this.runIteration(dataValues, estimatedNumIterations);
    }

    private void runIteration(Object[] dataValues, int estimatedNumIterations) {
        if (this.runStatus != 0) {
            return;
        }
        this.currentIteration = this.createIterationInfo(dataValues, estimatedNumIterations);
        this.getSpecificationContext().setCurrentIteration(this.currentIteration);
        this.supervisor.beforeIteration(this.currentIteration);
        this.invoke(this, this.createMethodInfoForDoRunIteration(), new Object[0]);
        this.supervisor.afterIteration(this.currentIteration);
        this.getSpecificationContext().setCurrentIteration(null);
        this.currentIteration = null;
    }

    private IterationInfo createIterationInfo(Object[] dataValues, int estimatedNumIterations) {
        IterationInfo result = new IterationInfo(this.currentFeature, dataValues, estimatedNumIterations);
        String iterationName = this.currentFeature.getIterationNameProvider().getName(result);
        result.setName(iterationName);
        Description description = Description.createTestDescription((Class)((Class)this.spec.getReflection()), (String)iterationName, (Annotation[])this.currentFeature.getFeatureMethod().getAnnotations());
        result.setDescription(description);
        return result;
    }

    private MethodInfo createMethodInfoForDoRunIteration() {
        MethodInfo result = new MethodInfo(){

            @Override
            public Object invoke(Object target, Object ... arguments) {
                BaseSpecRunner.this.doRunIteration();
                return null;
            }
        };
        result.setParent(this.currentFeature.getParent());
        result.setKind(MethodKind.ITERATION_EXECUTION);
        result.setFeature(this.currentFeature);
        result.setDescription(this.currentFeature.getDescription());
        for (IMethodInterceptor interceptor : this.currentFeature.getIterationInterceptors()) {
            result.addInterceptor(interceptor);
        }
        return result;
    }

    public void doRunIteration() {
        this.runSetup();
        this.runFeatureMethod();
        this.runCleanup();
    }

    protected int resetStatus(int scope) {
        if (RunStatus.scope(this.runStatus) <= scope) {
            this.runStatus = 0;
        }
        return this.runStatus;
    }

    protected void runParameterizedFeature() {
        throw new UnsupportedOperationException("This runner cannot run parameterized features");
    }

    private void runInitializer() {
        this.runInitializer(this.spec);
    }

    private void runInitializer(SpecInfo spec) {
        if (spec == null) {
            return;
        }
        this.invoke(this, this.createMethodInfoForDoRunInitializer(spec), spec);
    }

    private MethodInfo createMethodInfoForDoRunInitializer(final SpecInfo spec) {
        MethodInfo result = new MethodInfo(){

            @Override
            public Object invoke(Object target, Object ... arguments) {
                BaseSpecRunner.this.doRunInitializer(spec);
                return null;
            }
        };
        result.setParent(this.currentFeature.getParent());
        result.setKind(MethodKind.INITIALIZER);
        result.setFeature(this.currentFeature);
        result.setDescription(this.currentFeature.getDescription());
        for (IMethodInterceptor interceptor : spec.getInitializerInterceptors()) {
            result.addInterceptor(interceptor);
        }
        return result;
    }

    public void doRunInitializer(SpecInfo spec) {
        this.runInitializer(spec.getSuperSpec());
        if (this.runStatus != 0) {
            return;
        }
        this.invoke(this.currentInstance, spec.getInitializerMethod(), new Object[0]);
    }

    private void runSetup() {
        this.runSetup(this.spec);
    }

    private void runSetup(SpecInfo spec) {
        if (spec == null) {
            return;
        }
        this.invoke(this, this.createMethodInfoForDoRunSetup(spec), spec);
    }

    private MethodInfo createMethodInfoForDoRunSetup(final SpecInfo spec) {
        MethodInfo result = new MethodInfo(){

            @Override
            public Object invoke(Object target, Object ... arguments) {
                BaseSpecRunner.this.doRunSetup(spec);
                return null;
            }
        };
        result.setParent(this.currentFeature.getParent());
        result.setKind(MethodKind.SETUP);
        result.setFeature(this.currentFeature);
        result.setDescription(this.currentFeature.getDescription());
        for (IMethodInterceptor interceptor : spec.getSetupInterceptors()) {
            result.addInterceptor(interceptor);
        }
        return result;
    }

    public void doRunSetup(SpecInfo spec) {
        this.runSetup(spec.getSuperSpec());
        for (MethodInfo method : spec.getSetupMethods()) {
            if (this.runStatus != 0) {
                return;
            }
            method.setFeature(this.currentFeature);
            this.invoke(this.currentInstance, method, new Object[0]);
        }
    }

    private void runFeatureMethod() {
        if (this.runStatus != 0) {
            return;
        }
        this.invoke(this.currentInstance, this.currentFeature.getFeatureMethod(), this.currentIteration.getDataValues());
    }

    private void runCleanup() {
        this.runCleanup(this.spec);
    }

    private void runCleanup(SpecInfo spec) {
        if (spec == null) {
            return;
        }
        this.invoke(this, this.createMethodInfoForDoRunCleanup(spec), spec);
    }

    private MethodInfo createMethodInfoForDoRunCleanup(final SpecInfo spec) {
        MethodInfo result = new MethodInfo(){

            @Override
            public Object invoke(Object target, Object ... arguments) {
                BaseSpecRunner.this.doRunCleanup(spec);
                return null;
            }
        };
        result.setParent(this.currentFeature.getParent());
        result.setKind(MethodKind.CLEANUP);
        result.setFeature(this.currentFeature);
        result.setDescription(this.currentFeature.getDescription());
        for (IMethodInterceptor interceptor : spec.getCleanupInterceptors()) {
            result.addInterceptor(interceptor);
        }
        return result;
    }

    public void doRunCleanup(SpecInfo spec) {
        if (spec.getIsBottomSpec()) {
            this.runIterationCleanups();
            if (RunStatus.action(this.runStatus) == 2) {
                return;
            }
        }
        for (MethodInfo method : spec.getCleanupMethods()) {
            if (RunStatus.action(this.runStatus) == 2) {
                return;
            }
            this.invoke(this.currentInstance, method, new Object[0]);
        }
        this.runCleanup(spec.getSuperSpec());
    }

    private void runIterationCleanups() {
        for (Runnable cleanup : this.currentIteration.getCleanups()) {
            if (RunStatus.action(this.runStatus) == 2) {
                return;
            }
            try {
                cleanup.run();
            }
            catch (Throwable t) {
                ErrorInfo error = new ErrorInfo(CollectionUtil.getFirstElement(this.spec.getCleanupMethods()), t);
                this.runStatus = this.supervisor.error(error);
            }
        }
    }

    private void invoke(Object target, MethodInfo method, Object ... arguments) {
        if (method == null || method.isExcluded()) {
            return;
        }
        if (method.getInterceptors().isEmpty()) {
            this.invokeRaw(target, method, arguments);
            return;
        }
        MethodInvocation invocation = new MethodInvocation(this.currentFeature, this.currentIteration, this.sharedInstance, this.currentInstance, target, method, arguments);
        try {
            invocation.proceed();
        }
        catch (Throwable t) {
            ErrorInfo error = new ErrorInfo(method, t);
            this.runStatus = this.supervisor.error(error);
        }
    }

    protected Object invokeRaw(Object target, MethodInfo method, Object ... arguments) {
        try {
            return method.invoke(target, arguments);
        }
        catch (Throwable t) {
            this.runStatus = this.supervisor.error(new ErrorInfo(method, t));
            return null;
        }
    }

    protected SpecificationContext getSpecificationContext() {
        return (SpecificationContext)this.currentInstance.getSpecificationContext();
    }
}

