/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.mock.runtime;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.NamingStrategy;
import net.bytebuddy.TypeCache;
import net.bytebuddy.description.modifier.ModifierContributor;
import net.bytebuddy.description.modifier.SynchronizationState;
import net.bytebuddy.description.modifier.Visibility;
import net.bytebuddy.dynamic.Transformer;
import net.bytebuddy.implementation.FieldAccessor;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodDelegation;
import net.bytebuddy.implementation.bind.annotation.Morph;
import net.bytebuddy.implementation.bind.annotation.TargetMethodAnnotationDrivenBinder;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.CallbackFilter;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.Factory;
import net.sf.cglib.proxy.NoOp;
import org.spockframework.mock.CannotCreateMockException;
import org.spockframework.mock.ISpockMockObject;
import org.spockframework.mock.runtime.ByteBuddyInterceptorAdapter;
import org.spockframework.mock.runtime.ByteBuddyInvoker;
import org.spockframework.mock.runtime.CglibMockInterceptorAdapter;
import org.spockframework.mock.runtime.DynamicProxyMockInterceptorAdapter;
import org.spockframework.mock.runtime.IProxyBasedMockInterceptor;
import org.spockframework.mock.runtime.MockInstantiator;
import org.spockframework.runtime.InvalidSpecException;
import org.spockframework.util.ReflectionUtil;

public class ProxyBasedMockFactory {
    private static final boolean ignoreByteBuddy = Boolean.getBoolean("org.spockframework.mock.ignoreByteBuddy");
    private static final boolean byteBuddyAvailable = ReflectionUtil.isClassAvailable("net.bytebuddy.ByteBuddy");
    private static final boolean cglibAvailable = ReflectionUtil.isClassAvailable("net.sf.cglib.proxy.Enhancer");
    public static ProxyBasedMockFactory INSTANCE = new ProxyBasedMockFactory();

    public Object create(Class<?> mockType, List<Class<?>> additionalInterfaces, List<Object> constructorArgs, IProxyBasedMockInterceptor mockInterceptor, ClassLoader classLoader, boolean useObjenesis) throws CannotCreateMockException {
        Object proxy;
        if (mockType.isInterface()) {
            proxy = this.createDynamicProxyMock(mockType, additionalInterfaces, constructorArgs, mockInterceptor, classLoader);
        } else if (byteBuddyAvailable && !ignoreByteBuddy) {
            proxy = ByteBuddyMockFactory.createMock(mockType, additionalInterfaces, constructorArgs, mockInterceptor, classLoader, useObjenesis);
        } else if (cglibAvailable) {
            proxy = CglibMockFactory.createMock(mockType, additionalInterfaces, constructorArgs, mockInterceptor, classLoader, useObjenesis);
        } else {
            throw new CannotCreateMockException(mockType, ". Mocking of non-interface types requires a code generation library. Please put byte-buddy-1.6.4 or cglib-nodep-3.2 or higher on the class path.");
        }
        return proxy;
    }

    private Object createDynamicProxyMock(Class<?> mockType, List<Class<?>> additionalInterfaces, List<Object> constructorArgs, IProxyBasedMockInterceptor mockInterceptor, ClassLoader classLoader) {
        if (constructorArgs != null) {
            throw new InvalidSpecException("Interface based mocks may not have constructor arguments");
        }
        ArrayList interfaces = new ArrayList();
        interfaces.add(mockType);
        interfaces.addAll(additionalInterfaces);
        interfaces.add(ISpockMockObject.class);
        return Proxy.newProxyInstance(classLoader, interfaces.toArray(new Class[interfaces.size()]), (InvocationHandler)new DynamicProxyMockInterceptorAdapter(mockInterceptor));
    }

    private static class CglibMockFactory {
        private CglibMockFactory() {
        }

        static Object createMock(Class<?> type, List<Class<?>> additionalInterfaces, List<Object> constructorArgs, IProxyBasedMockInterceptor interceptor, ClassLoader classLoader, boolean useObjenesis) {
            ConstructorFriendlyEnhancer enhancer = new ConstructorFriendlyEnhancer();
            enhancer.setClassLoader(classLoader);
            enhancer.setSuperclass(type);
            ArrayList interfaces = new ArrayList();
            interfaces.addAll(additionalInterfaces);
            interfaces.add(ISpockMockObject.class);
            enhancer.setInterfaces(interfaces.toArray(new Class[interfaces.size()]));
            enhancer.setCallbackFilter(BridgeMethodAwareCallbackFilter.INSTANCE);
            CglibMockInterceptorAdapter cglibInterceptor = new CglibMockInterceptorAdapter(interceptor);
            enhancer.setCallbackTypes(new Class[]{cglibInterceptor.getClass(), NoOp.class});
            Class enhancedType = enhancer.createClass();
            Object proxy = MockInstantiator.instantiate(type, enhancedType, constructorArgs, useObjenesis);
            ((Factory)proxy).setCallbacks(new Callback[]{cglibInterceptor, NoOp.INSTANCE});
            return proxy;
        }

        static class BridgeMethodAwareCallbackFilter
        implements CallbackFilter {
            static BridgeMethodAwareCallbackFilter INSTANCE = new BridgeMethodAwareCallbackFilter();

            BridgeMethodAwareCallbackFilter() {
            }

            public int accept(Method method) {
                return method.isBridge() ? 1 : 0;
            }
        }

        static class ConstructorFriendlyEnhancer
        extends Enhancer {
            ConstructorFriendlyEnhancer() {
            }

            protected void filterConstructors(Class clazz, List constructors) {
            }
        }
    }

    private static class ByteBuddyMockFactory {
        private static final TypeCache<TypeCache.SimpleKey> CACHE = new TypeCache.WithInlineExpunction(TypeCache.Sort.SOFT);

        private ByteBuddyMockFactory() {
        }

        static Object createMock(final Class<?> type, final List<Class<?>> additionalInterfaces, List<Object> constructorArgs, IProxyBasedMockInterceptor interceptor, final ClassLoader classLoader, boolean useObjenesis) {
            Class enhancedType = CACHE.findOrInsert(classLoader, (Object)new TypeCache.SimpleKey(type, additionalInterfaces), new Callable<Class<?>>(){

                @Override
                public Class<?> call() throws Exception {
                    return new ByteBuddy().with((NamingStrategy)new NamingStrategy.SuffixingRandom("SpockMock")).ignore((ElementMatcher)ElementMatchers.none()).subclass(type).implement(additionalInterfaces).implement(new Type[]{ISpockMockObject.class}).method((ElementMatcher)ElementMatchers.any()).intercept((Implementation)MethodDelegation.withDefaultConfiguration().withBinders(new TargetMethodAnnotationDrivenBinder.ParameterBinder[]{Morph.Binder.install(ByteBuddyInvoker.class)}).to(ByteBuddyInterceptorAdapter.class)).transform(Transformer.ForMethod.withModifiers((ModifierContributor.ForMethod[])new ModifierContributor.ForMethod[]{SynchronizationState.PLAIN, Visibility.PUBLIC})).implement(new Type[]{ByteBuddyInterceptorAdapter.InterceptorAccess.class}).intercept((Implementation)FieldAccessor.ofField((String)"$spock_interceptor")).defineField("$spock_interceptor", IProxyBasedMockInterceptor.class, new ModifierContributor.ForField[]{Visibility.PRIVATE}).make().load(classLoader).getLoaded();
                }
            }, CACHE);
            Object proxy = MockInstantiator.instantiate(type, enhancedType, constructorArgs, useObjenesis);
            ((ByteBuddyInterceptorAdapter.InterceptorAccess)proxy).$spock_set(interceptor);
            return proxy;
        }
    }
}

