/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.mock.runtime;

import groovy.lang.MetaClass;
import groovy.lang.MissingMethodException;
import groovy.lang.MissingPropertyException;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.spockframework.mock.IMockConfiguration;
import org.spockframework.mock.IMockController;
import org.spockframework.mock.IResponseGenerator;
import org.spockframework.mock.ISpockMockObject;
import org.spockframework.mock.runtime.IProxyBasedMockInterceptor;
import org.spockframework.mock.runtime.MockInvocation;
import org.spockframework.mock.runtime.MockObject;
import org.spockframework.mock.runtime.StaticMockMethod;
import org.spockframework.runtime.GroovyRuntimeUtil;
import spock.lang.Specification;

public class GroovyMockInterceptor
implements IProxyBasedMockInterceptor {
    private final IMockConfiguration mockConfiguration;
    private final Specification specification;
    private final MetaClass mockMetaClass;

    public GroovyMockInterceptor(IMockConfiguration mockConfiguration, Specification specification, MetaClass mockMetaClass) {
        this.mockConfiguration = mockConfiguration;
        this.specification = specification;
        this.mockMetaClass = mockMetaClass;
    }

    @Override
    public Object intercept(Object target, Method method, Object[] arguments, IResponseGenerator realMethodInvoker) {
        MockObject mockObject = new MockObject(this.mockConfiguration.getName(), this.mockConfiguration.getExactType(), target, this.mockConfiguration.isVerified(), this.mockConfiguration.isGlobal(), this.mockConfiguration.getDefaultResponse(), this.specification, this);
        if (method.getDeclaringClass() == ISpockMockObject.class) {
            return mockObject;
        }
        Object[] normalizedArgs = GroovyRuntimeUtil.asUnwrappedArgumentArray(arguments);
        if (this.isMethod(method, "getMetaClass", new Class[0])) {
            return this.mockMetaClass;
        }
        if (this.isMethod(method, "invokeMethod", String.class, Object.class)) {
            return GroovyRuntimeUtil.invokeMethod(target, (String)normalizedArgs[0], GroovyRuntimeUtil.asArgumentArray(normalizedArgs[1]));
        }
        if (this.isMethod(method, "getProperty", String.class)) {
            String methodName = GroovyRuntimeUtil.propertyToMethodName("get", (String)normalizedArgs[0]);
            return GroovyRuntimeUtil.invokeMethod(target, methodName, new Object[0]);
        }
        if (this.isMethod(method, "setProperty", String.class, Object.class)) {
            String methodName = GroovyRuntimeUtil.propertyToMethodName("set", (String)normalizedArgs[0]);
            return GroovyRuntimeUtil.invokeMethod(target, methodName, normalizedArgs[1]);
        }
        if (this.isMethod(method, "methodMissing", String.class, Object.class)) {
            throw new MissingMethodException((String)normalizedArgs[0], this.mockConfiguration.getType(), new Object[]{normalizedArgs[1]}, false);
        }
        if (this.isMethod(method, "propertyMissing", String.class)) {
            throw new MissingPropertyException((String)normalizedArgs[0], this.mockConfiguration.getType());
        }
        StaticMockMethod mockMethod = new StaticMockMethod(method, this.mockConfiguration.getExactType());
        MockInvocation invocation = new MockInvocation(mockObject, mockMethod, Arrays.asList(normalizedArgs), realMethodInvoker);
        IMockController controller = this.specification.getSpecificationContext().getMockController();
        return controller.handle(invocation);
    }

    private boolean isMethod(Method method, String name, Class<?> ... parameterTypes) {
        return method.getName().equals(name) && Arrays.equals(method.getParameterTypes(), parameterTypes);
    }

    @Override
    public void attach(Specification specification) {
    }

    @Override
    public void detach() {
    }
}

