/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.compiler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassCodeExpressionTransformer;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.VariableScope;
import org.codehaus.groovy.ast.expr.ArrayExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ExpressionTransformer;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.syntax.Token;
import org.spockframework.compiler.AstUtil;
import org.spockframework.compiler.IRewriteResources;
import org.spockframework.compiler.InstanceFieldAccessChecker;
import org.spockframework.compiler.InvalidSpecCompileException;
import org.spockframework.compiler.model.Method;
import org.spockframework.compiler.model.Spec;
import org.spockframework.compiler.model.WhereBlock;
import org.spockframework.util.InternalIdentifiers;
import org.spockframework.util.ObjectUtil;

public class WhereBlockRewriter {
    private final WhereBlock whereBlock;
    private final IRewriteResources resources;
    private final InstanceFieldAccessChecker instanceFieldAccessChecker;
    private int dataProviderCount = 0;
    private final List<Parameter> dataProcessorParams = new ArrayList<Parameter>();
    private final List<Statement> dataProcessorStats = new ArrayList<Statement>();
    private final List<VariableExpression> dataProcessorVars = new ArrayList<VariableExpression>();

    private WhereBlockRewriter(WhereBlock whereBlock, IRewriteResources resources) {
        this.whereBlock = whereBlock;
        this.resources = resources;
        this.instanceFieldAccessChecker = new InstanceFieldAccessChecker(resources);
    }

    public static void rewrite(WhereBlock block, IRewriteResources resources) {
        new WhereBlockRewriter(block, resources).rewrite();
    }

    private void rewrite() {
        ListIterator<Statement> stats = ((List)this.whereBlock.getAst()).listIterator();
        while (stats.hasNext()) {
            try {
                this.rewriteWhereStat(stats);
            }
            catch (InvalidSpecCompileException e) {
                this.resources.getErrorReporter().error(e);
            }
        }
        ((List)this.whereBlock.getAst()).clear();
        this.handleFeatureParameters();
        this.createDataProcessorMethod();
    }

    private void rewriteWhereStat(ListIterator<Statement> stats) throws InvalidSpecCompileException {
        int type;
        Statement stat = stats.next();
        BinaryExpression binExpr = AstUtil.getExpression(stat, BinaryExpression.class);
        if (binExpr == null || binExpr.getClass() != BinaryExpression.class) {
            WhereBlockRewriter.notAParameterization((ASTNode)stat);
        }
        if ((type = binExpr.getOperation().getType()) == 280) {
            Expression leftExpr = binExpr.getLeftExpression();
            if (leftExpr instanceof VariableExpression) {
                this.rewriteSimpleParameterization(binExpr, (ASTNode)stat);
            } else if (leftExpr instanceof ListExpression) {
                this.rewriteMultiParameterization(binExpr, stat);
            } else {
                WhereBlockRewriter.notAParameterization((ASTNode)stat);
            }
        } else if (type == 100) {
            this.rewriteDerivedParameterization(binExpr, stat);
        } else if (this.getOrExpression((Expression)binExpr) != null) {
            stats.previous();
            this.rewriteTableLikeParameterization(stats);
        } else {
            WhereBlockRewriter.notAParameterization((ASTNode)stat);
        }
    }

    private void createDataProviderMethod(Expression dataProviderExpr, int nextDataVariableIndex) {
        this.instanceFieldAccessChecker.check(dataProviderExpr);
        dataProviderExpr = dataProviderExpr.transformExpression((ExpressionTransformer)new DataTablePreviousVariableTransformer());
        MethodNode method = new MethodNode(InternalIdentifiers.getDataProviderName(((MethodNode)((Method)this.whereBlock.getParent()).getAst()).getName(), this.dataProviderCount++), 4097, ClassHelper.OBJECT_TYPE, this.getPreviousParameters(nextDataVariableIndex), ClassNode.EMPTY_ARRAY, (Statement)new BlockStatement(Arrays.asList(new ReturnStatement(new ExpressionStatement(dataProviderExpr))), new VariableScope()));
        method.addAnnotation(this.createDataProviderAnnotation(dataProviderExpr, nextDataVariableIndex));
        ((ClassNode)((Spec)((Method)this.whereBlock.getParent()).getParent()).getAst()).addMethod(method);
    }

    private Parameter[] getPreviousParameters(int nextDataVariableIndex) {
        Parameter[] results = new Parameter[nextDataVariableIndex];
        for (int i = 0; i < nextDataVariableIndex; ++i) {
            results[i] = new Parameter(ClassHelper.DYNAMIC_TYPE, this.dataProcessorVars.get(i).getName());
        }
        return results;
    }

    private AnnotationNode createDataProviderAnnotation(Expression dataProviderExpr, int nextDataVariableIndex) {
        AnnotationNode ann = new AnnotationNode(this.resources.getAstNodeCache().DataProviderMetadata);
        ann.addMember("line", (Expression)new ConstantExpression((Object)dataProviderExpr.getLineNumber()));
        ArrayList<ConstantExpression> dataVariableNames = new ArrayList<ConstantExpression>();
        for (int i = nextDataVariableIndex; i < this.dataProcessorVars.size(); ++i) {
            dataVariableNames.add(new ConstantExpression((Object)this.dataProcessorVars.get(i).getName()));
        }
        ann.addMember("dataVariables", (Expression)new ListExpression(dataVariableNames));
        return ann;
    }

    private Parameter createDataProcessorParameter() {
        Parameter p = new Parameter(ClassHelper.DYNAMIC_TYPE, "$spock_p" + this.dataProcessorParams.size());
        this.dataProcessorParams.add(p);
        return p;
    }

    private void rewriteSimpleParameterization(BinaryExpression binExpr, ASTNode sourcePos) throws InvalidSpecCompileException {
        int nextDataVariableIndex = this.dataProcessorVars.size();
        Parameter dataProcessorParameter = this.createDataProcessorParameter();
        VariableExpression arg = (VariableExpression)binExpr.getLeftExpression();
        VariableExpression dataVar = this.createDataProcessorVariable((Expression)arg, sourcePos);
        ExpressionStatement exprStat = new ExpressionStatement((Expression)new DeclarationExpression(dataVar, Token.newSymbol((int)100, (int)-1, (int)-1), (Expression)new VariableExpression((Variable)dataProcessorParameter)));
        exprStat.setSourcePosition(sourcePos);
        this.dataProcessorStats.add((Statement)exprStat);
        this.createDataProviderMethod(binExpr.getRightExpression(), nextDataVariableIndex);
    }

    private void rewriteMultiParameterization(BinaryExpression binExpr, Statement enclosingStat) throws InvalidSpecCompileException {
        int nextDataVariableIndex = this.dataProcessorVars.size();
        Parameter dataProcessorParameter = this.createDataProcessorParameter();
        ListExpression list = (ListExpression)binExpr.getLeftExpression();
        List listElems = list.getExpressions();
        for (int i = 0; i < listElems.size(); ++i) {
            Expression listElem = (Expression)listElems.get(i);
            if (AstUtil.isWildcardRef(listElem)) continue;
            VariableExpression dataVar = this.createDataProcessorVariable(listElem, (ASTNode)enclosingStat);
            ExpressionStatement exprStat = new ExpressionStatement((Expression)new DeclarationExpression(dataVar, Token.newSymbol((int)100, (int)-1, (int)-1), (Expression)AstUtil.createGetAtMethod((Expression)new VariableExpression((Variable)dataProcessorParameter), i)));
            exprStat.setSourcePosition((ASTNode)enclosingStat);
            this.dataProcessorStats.add((Statement)exprStat);
        }
        this.createDataProviderMethod(binExpr.getRightExpression(), nextDataVariableIndex);
    }

    private void rewriteDerivedParameterization(BinaryExpression parameterization, Statement enclosingStat) throws InvalidSpecCompileException {
        VariableExpression dataVar = this.createDataProcessorVariable(parameterization.getLeftExpression(), (ASTNode)enclosingStat);
        ExpressionStatement exprStat = new ExpressionStatement((Expression)new DeclarationExpression(dataVar, Token.newSymbol((int)100, (int)-1, (int)-1), parameterization.getRightExpression()));
        exprStat.setSourcePosition((ASTNode)enclosingStat);
        this.dataProcessorStats.add((Statement)exprStat);
    }

    private void rewriteTableLikeParameterization(ListIterator<Statement> stats) throws InvalidSpecCompileException {
        LinkedList<List<Expression>> rows = new LinkedList<List<Expression>>();
        while (stats.hasNext()) {
            Statement stat = stats.next();
            BinaryExpression orExpr = this.getOrExpression(stat);
            if (orExpr == null) {
                stats.previous();
                break;
            }
            ArrayList<Expression> row = new ArrayList<Expression>();
            this.splitRow((Expression)orExpr, row);
            if (rows.size() > 0 && rows.getLast().size() != row.size()) {
                throw new InvalidSpecCompileException((ASTNode)stat, String.format("Row in data table has wrong number of elements (%s instead of %s)", row.size(), rows.getLast().size()), new Object[0]);
            }
            rows.add(row);
        }
        for (List<Expression> column : this.transposeTable(rows)) {
            this.turnIntoSimpleParameterization(column);
        }
    }

    List<List<Expression>> transposeTable(List<List<Expression>> rows) {
        ArrayList<List<Expression>> columns = new ArrayList<List<Expression>>();
        if (rows.isEmpty()) {
            return columns;
        }
        for (int i = 0; i < rows.get(0).size(); ++i) {
            columns.add(new ArrayList());
        }
        for (List<Expression> row : rows) {
            for (int i = 0; i < row.size(); ++i) {
                ((List)columns.get(i)).add(row.get(i));
            }
        }
        return columns;
    }

    private void turnIntoSimpleParameterization(List<Expression> column) throws InvalidSpecCompileException {
        VariableExpression varExpr = ObjectUtil.asInstance(column.get(0), VariableExpression.class);
        if (varExpr == null) {
            throw new InvalidSpecCompileException((ASTNode)column.get(0), "Header of data table may only contain variable names", new Object[0]);
        }
        if (AstUtil.isWildcardRef((Expression)varExpr)) {
            return;
        }
        ListExpression listExpr = new ListExpression(column.subList(1, column.size()));
        BinaryExpression binExpr = new BinaryExpression((Expression)varExpr, Token.newSymbol((int)280, (int)-1, (int)-1), (Expression)listExpr);
        this.rewriteSimpleParameterization(binExpr, (ASTNode)varExpr);
    }

    private void splitRow(Expression row, List<Expression> parts) {
        BinaryExpression orExpr = this.getOrExpression(row);
        if (orExpr == null) {
            parts.add(row);
        } else {
            this.splitRow(orExpr.getLeftExpression(), parts);
            this.splitRow(orExpr.getRightExpression(), parts);
        }
    }

    private BinaryExpression getOrExpression(Statement stat) {
        Expression expr = AstUtil.getExpression(stat, Expression.class);
        return this.getOrExpression(expr);
    }

    private BinaryExpression getOrExpression(Expression expr) {
        BinaryExpression binExpr = ObjectUtil.asInstance(expr, BinaryExpression.class);
        if (binExpr == null) {
            return null;
        }
        int binExprType = binExpr.getOperation().getType();
        if (binExprType == 340 || binExprType == 162) {
            return binExpr;
        }
        return null;
    }

    private VariableExpression createDataProcessorVariable(Expression varExpr, ASTNode sourcePos) throws InvalidSpecCompileException {
        if (!(varExpr instanceof VariableExpression)) {
            WhereBlockRewriter.notAParameterization(sourcePos);
        }
        VariableExpression typedVarExpr = (VariableExpression)varExpr;
        this.verifyDataProcessorVariable(typedVarExpr);
        VariableExpression result = new VariableExpression(typedVarExpr.getName(), typedVarExpr.getType());
        this.dataProcessorVars.add(result);
        return result;
    }

    private void verifyDataProcessorVariable(VariableExpression varExpr) {
        Variable accessedVar = varExpr.getAccessedVariable();
        if (accessedVar instanceof VariableExpression) {
            this.resources.getErrorReporter().error((ASTNode)varExpr, "A variable named '%s' already exists in this scope", varExpr.getName());
            return;
        }
        if (this.isDataProcessorVariable(varExpr.getName())) {
            this.resources.getErrorReporter().error((ASTNode)varExpr, "Duplicate declaration of data variable '%s'", varExpr.getName());
            return;
        }
        if (((MethodNode)((Method)this.whereBlock.getParent()).getAst()).getParameters().length > 0 && !(accessedVar instanceof Parameter)) {
            this.resources.getErrorReporter().error((ASTNode)varExpr, "Data variable '%s' needs to be declared as method parameter", varExpr.getName());
        }
    }

    private boolean isDataProcessorVariable(String name) {
        for (VariableExpression var : this.dataProcessorVars) {
            if (!var.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    private void handleFeatureParameters() {
        Parameter[] parameters = ((MethodNode)((Method)this.whereBlock.getParent()).getAst()).getParameters();
        if (parameters.length == 0) {
            this.addFeatureParameters();
        } else {
            this.checkAllParametersAreDataVariables(parameters);
        }
    }

    private void checkAllParametersAreDataVariables(Parameter[] parameters) {
        for (Parameter param : parameters) {
            if (this.isDataProcessorVariable(param.getName())) continue;
            this.resources.getErrorReporter().error((ASTNode)param, "Parameter '%s' does not refer to a data variable", param.getName());
        }
    }

    private void addFeatureParameters() {
        Parameter[] parameters = new Parameter[this.dataProcessorVars.size()];
        for (int i = 0; i < this.dataProcessorVars.size(); ++i) {
            parameters[i] = new Parameter(ClassHelper.DYNAMIC_TYPE, this.dataProcessorVars.get(i).getName());
        }
        ((MethodNode)((Method)this.whereBlock.getParent()).getAst()).setParameters(parameters);
    }

    private void createDataProcessorMethod() {
        if (this.dataProcessorVars.isEmpty()) {
            return;
        }
        this.dataProcessorStats.add((Statement)new ReturnStatement((Expression)new ArrayExpression(ClassHelper.OBJECT_TYPE, this.dataProcessorVars)));
        BlockStatement blockStat = new BlockStatement(this.dataProcessorStats, new VariableScope());
        new DataProcessorVariableRewriter().visitBlockStatement(blockStat);
        ((ClassNode)((Spec)((Method)this.whereBlock.getParent()).getParent()).getAst()).addMethod(new MethodNode(InternalIdentifiers.getDataProcessorName(((MethodNode)((Method)this.whereBlock.getParent()).getAst()).getName()), 4097, ClassHelper.OBJECT_TYPE, this.dataProcessorParams.toArray(new Parameter[this.dataProcessorParams.size()]), ClassNode.EMPTY_ARRAY, (Statement)blockStat));
    }

    private static void notAParameterization(ASTNode stat) throws InvalidSpecCompileException {
        throw new InvalidSpecCompileException(stat, "where-blocks may only contain parameterizations (e.g. 'salary << [1000, 5000, 9000]; salaryk = salary / 1000')", new Object[0]);
    }

    private class DataTablePreviousVariableTransformer
    extends ClassCodeExpressionTransformer {
        private int depth = 0;
        private int rowIndex = 0;

        private DataTablePreviousVariableTransformer() {
        }

        protected SourceUnit getSourceUnit() {
            return null;
        }

        public Expression transform(Expression expression) {
            if (expression instanceof VariableExpression && WhereBlockRewriter.this.isDataProcessorVariable(expression.getText())) {
                return AstUtil.createGetAtMethod(expression, this.rowIndex);
            }
            ++this.depth;
            Expression transform = super.transform(expression);
            --this.depth;
            if (this.depth == 0) {
                ++this.rowIndex;
            }
            return transform;
        }
    }

    private class DataProcessorVariableRewriter
    extends ClassCodeVisitorSupport {
        private DataProcessorVariableRewriter() {
        }

        protected SourceUnit getSourceUnit() {
            throw new UnsupportedOperationException("getSourceUnit");
        }

        public void visitClosureExpression(ClosureExpression expr) {
            super.visitClosureExpression(expr);
            AstUtil.fixUpLocalVariables(WhereBlockRewriter.this.dataProcessorVars, expr.getVariableScope(), true);
        }

        public void visitBlockStatement(BlockStatement stat) {
            super.visitBlockStatement(stat);
            AstUtil.fixUpLocalVariables(WhereBlockRewriter.this.dataProcessorVars, stat.getVariableScope(), false);
        }
    }
}

