/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.http.core;

import java.util.concurrent.TimeUnit;
import org.simpleframework.http.core.ContainerEvent;
import org.simpleframework.http.core.Initiator;
import org.simpleframework.http.core.Monitor;
import org.simpleframework.http.core.Timer;
import org.simpleframework.http.message.Entity;
import org.simpleframework.transport.Channel;
import org.simpleframework.transport.Sender;
import org.simpleframework.transport.trace.Trace;

class FlushMonitor
implements Monitor {
    private Initiator reactor;
    private Channel channel;
    private Trace trace;
    private Timer timer = new Timer(TimeUnit.MILLISECONDS);
    private boolean closed;
    private boolean error;

    public FlushMonitor(Initiator reactor, Entity entity) {
        this.channel = entity.getChannel();
        this.trace = this.channel.getTrace();
        this.reactor = reactor;
    }

    public void close(Sender sender) {
        try {
            if (!this.isClosed()) {
                this.closed = true;
                this.timer.set();
                this.trace.trace((Object)ContainerEvent.RESPONSE_FINISHED);
                sender.close();
            }
        }
        catch (Exception cause) {
            this.trace.trace((Object)ContainerEvent.ERROR, cause);
            this.fail(sender);
        }
    }

    public void error(Sender sender) {
        try {
            if (!this.isClosed()) {
                this.error = true;
                this.timer.set();
                this.trace.trace((Object)ContainerEvent.RESPONSE_FINISHED);
                sender.close();
            }
        }
        catch (Exception cause) {
            this.trace.trace((Object)ContainerEvent.ERROR, cause);
            this.fail(sender);
        }
    }

    public void ready(Sender sender) {
        try {
            if (!this.isClosed()) {
                this.closed = true;
                sender.flush();
                this.timer.set();
                this.trace.trace((Object)ContainerEvent.RESPONSE_FINISHED);
                this.reactor.start(this.channel);
            }
        }
        catch (Exception cause) {
            this.trace.trace((Object)ContainerEvent.ERROR, cause);
            this.fail(sender);
        }
    }

    private void fail(Sender sender) {
        try {
            sender.close();
        }
        catch (Exception cause) {
            this.trace.trace((Object)ContainerEvent.ERROR, cause);
        }
    }

    public boolean isClosed() {
        return this.closed || this.error;
    }

    public boolean isError() {
        return this.error;
    }

    public long getTime() {
        return this.timer.get();
    }
}

