/*
 * Decompiled with CFR 0.152.
 */
package quickfix;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import quickfix.Group;
import quickfix.Message;
import quickfix.MessageFactory;
import quickfix.MessageUtils;

public class DefaultMessageFactory
implements MessageFactory {
    private final Map<String, MessageFactory> messageFactories = new ConcurrentHashMap<String, MessageFactory>();

    public DefaultMessageFactory() {
        this.addFactory("FIX.4.0");
        this.addFactory("FIX.4.1");
        this.addFactory("FIX.4.2");
        this.addFactory("FIX.4.3");
        this.addFactory("FIX.4.4");
        this.addFactory("FIXT.1.1");
        this.addFactory("FIX.5.0");
        this.addFactory("FIX.5.0SP1");
        this.addFactory("FIX.5.0SP2");
    }

    private void addFactory(String beginString) {
        String packageVersion = beginString.replace(".", "").toLowerCase();
        try {
            this.addFactory(beginString, "quickfix." + packageVersion + ".MessageFactory");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public void addFactory(String beginString, String factoryClassName) throws ClassNotFoundException {
        Class<?> factoryClass = null;
        try {
            factoryClass = Class.forName(factoryClassName);
        }
        catch (ClassNotFoundException e) {
            Thread.currentThread().getContextClassLoader().loadClass(factoryClassName);
        }
        if (factoryClass != null) {
            this.addFactory(beginString, factoryClass);
        }
    }

    public void addFactory(String beginString, Class<? extends MessageFactory> factoryClass) {
        try {
            MessageFactory factory = factoryClass.newInstance();
            this.messageFactories.put(beginString, factory);
        }
        catch (Exception e) {
            throw new RuntimeException("can't instantiate " + factoryClass.getName(), e);
        }
    }

    @Override
    public Message create(String beginString, String msgType) {
        MessageFactory messageFactory = this.messageFactories.get(beginString);
        if (beginString.equals("FIXT.1.1") && !MessageUtils.isAdminMessage(msgType)) {
            messageFactory = this.messageFactories.get("FIX.5.0");
        }
        if (messageFactory != null) {
            return messageFactory.create(beginString, msgType);
        }
        Message message = new Message();
        message.getHeader().setString(35, msgType);
        return message;
    }

    @Override
    public Group create(String beginString, String msgType, int correspondingFieldID) {
        MessageFactory messageFactory = this.messageFactories.get(beginString);
        if (messageFactory != null) {
            return messageFactory.create(beginString, msgType, correspondingFieldID);
        }
        throw new IllegalArgumentException("Unsupported FIX version: " + beginString);
    }
}

