/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.ckb.sign.signer;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import org.nervos.ckb.crypto.Keccak256;
import org.nervos.ckb.crypto.secp256k1.ECKeyPair;
import org.nervos.ckb.crypto.secp256k1.Sign;
import org.nervos.ckb.sign.Context;
import org.nervos.ckb.sign.ScriptGroup;
import org.nervos.ckb.sign.ScriptSigner;
import org.nervos.ckb.type.Script;
import org.nervos.ckb.type.Transaction;
import org.nervos.ckb.type.WitnessArgs;
import org.nervos.ckb.utils.MoleculeConverter;

public class PwSigner
implements ScriptSigner {
    @Override
    public boolean signTransaction(Transaction transaction, ScriptGroup scriptGroup, Context context) {
        Script script = scriptGroup.getScript();
        ECKeyPair keyPair = context.getKeyPair();
        if (this.isMatched(keyPair, script.args)) {
            return this.signTransactionInPlace(transaction, scriptGroup, keyPair);
        }
        return false;
    }

    private boolean signTransactionInPlace(Transaction transaction, ScriptGroup scriptGroup, ECKeyPair keyPair) {
        byte[] signature = PwSigner.signTransactionETH(transaction, scriptGroup, keyPair);
        int index = scriptGroup.getInputIndices().get(0);
        List<byte[]> witnesses = transaction.witnesses;
        WitnessArgs witnessArgs = WitnessArgs.unpack(witnesses.get(index));
        witnessArgs.setLock(signature);
        witnesses.set(index, witnessArgs.pack().toByteArray());
        return true;
    }

    public static byte[] signTransactionETH(Transaction transaction, ScriptGroup scriptGroup, ECKeyPair keyPair) {
        Keccak256 keccak256 = new Keccak256();
        byte[] txHash = transaction.computeHash();
        keccak256.update(txHash);
        List<byte[]> witnesses = transaction.witnesses;
        for (int i : scriptGroup.getInputIndices()) {
            byte[] witness = witnesses.get(i);
            keccak256.update(MoleculeConverter.packUint64(witness.length).toByteArray());
            keccak256.update(witness);
        }
        byte[] digest = keccak256.doFinal();
        return PwSigner.ethereumPersonalSign(digest, keyPair);
    }

    private static byte[] ethereumPersonalSign(byte[] message, ECKeyPair keyPair) {
        byte[] prefix = ("\u0019Ethereum Signed Message:\n" + message.length).getBytes(StandardCharsets.UTF_8);
        byte[] encodedMessage = new byte[prefix.length + message.length];
        System.arraycopy(prefix, 0, encodedMessage, 0, prefix.length);
        System.arraycopy(message, 0, encodedMessage, prefix.length, message.length);
        Keccak256 keccak256 = new Keccak256();
        keccak256.update(encodedMessage);
        byte[] digest = keccak256.doFinal();
        return Sign.signMessage((byte[])digest, (ECKeyPair)keyPair).getSignature();
    }

    public boolean isMatched(ECKeyPair keyPair, byte[] scriptArgs) {
        if (scriptArgs == null || keyPair == null) {
            return false;
        }
        Keccak256 keccak256 = new Keccak256();
        byte[] encodedPublicKey = keyPair.getEncodedPublicKey(false);
        keccak256.update(Arrays.copyOfRange(encodedPublicKey, 1, encodedPublicKey.length));
        byte[] publicKeyHash = keccak256.doFinal();
        byte[] ethereumAddress = Arrays.copyOfRange(publicKeyHash, publicKeyHash.length - 20, publicKeyHash.length);
        return Arrays.equals(scriptArgs, ethereumAddress);
    }
}

