/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.ckb.sign.omnilock.molecule;

import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.nervos.ckb.sign.omnilock.molecule.SmtProofEntry;
import org.nervos.ckb.type.base.DynamicVector;
import org.nervos.ckb.type.base.MoleculeException;
import org.nervos.ckb.type.base.MoleculeUtils;

public final class SmtProofEntryVec
extends DynamicVector {
    public static Class ITEM_TYPE = SmtProofEntry.class;
    private SmtProofEntry[] items;

    private SmtProofEntryVec() {
    }

    @Nonnull
    public SmtProofEntry get(int i) {
        return this.items[i];
    }

    @Nullable
    public SmtProofEntry[] getItems() {
        return this.items;
    }

    public int getItemCount() {
        return this.items.length;
    }

    public Class getItemType() {
        return ITEM_TYPE;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(@Nonnull byte[] buf) {
        return new Builder(buf);
    }

    static /* synthetic */ byte[] access$302(SmtProofEntryVec x0, byte[] x1) {
        x0.buf = x1;
        return x1;
    }

    static /* synthetic */ SmtProofEntry[] access$402(SmtProofEntryVec x0, SmtProofEntry[] x1) {
        x0.items = x1;
        return x1;
    }

    public static final class Builder {
        private SmtProofEntry[] items;

        private Builder() {
            this.items = new SmtProofEntry[0];
        }

        private Builder(@Nonnull byte[] buf) {
            Objects.requireNonNull(buf);
            int size = MoleculeUtils.littleEndianBytes4ToInt((byte[])buf, (int)0);
            if (buf.length != size) {
                throw MoleculeException.invalidByteSize((int)size, (int)buf.length, SmtProofEntryVec.class);
            }
            int[] offsets = MoleculeUtils.getOffsets((byte[])buf);
            this.items = new SmtProofEntry[offsets.length - 1];
            for (int i = 0; i < this.items.length; ++i) {
                byte[] itemBuf = Arrays.copyOfRange(buf, offsets[i], offsets[i + 1]);
                this.items[i] = SmtProofEntry.builder(itemBuf).build();
            }
        }

        public Builder add(@Nonnull SmtProofEntry item) {
            Objects.requireNonNull(item);
            SmtProofEntry[] originalItems = this.items;
            this.items = new SmtProofEntry[originalItems.length + 1];
            System.arraycopy(originalItems, 0, this.items, 0, originalItems.length);
            this.items[this.items.length - 1] = item;
            return this;
        }

        public Builder add(@Nonnull SmtProofEntry[] items) {
            Objects.requireNonNull(items);
            SmtProofEntry[] originalItems = this.items;
            this.items = new SmtProofEntry[originalItems.length + items.length];
            System.arraycopy(originalItems, 0, this.items, 0, originalItems.length);
            System.arraycopy(items, 0, this.items, originalItems.length, items.length);
            return this;
        }

        public Builder set(int i, @Nonnull SmtProofEntry item) {
            Objects.requireNonNull(item);
            this.items[i] = item;
            return this;
        }

        public Builder set(@Nonnull SmtProofEntry[] items) {
            Objects.requireNonNull(items);
            this.items = items;
            return this;
        }

        public Builder remove(int i) {
            if (i < 0 || i >= this.items.length) {
                throw new ArrayIndexOutOfBoundsException(i);
            }
            SmtProofEntry[] originalItems = this.items;
            this.items = new SmtProofEntry[originalItems.length - 1];
            System.arraycopy(originalItems, 0, this.items, 0, i);
            System.arraycopy(originalItems, i + 1, this.items, i, originalItems.length - i - 1);
            return this;
        }

        public SmtProofEntryVec build() {
            int i;
            int size = 4 + 4 * this.items.length;
            for (int i2 = 0; i2 < this.items.length; ++i2) {
                size += this.items[i2].getSize();
            }
            byte[] buf = new byte[size];
            MoleculeUtils.setInt((int)size, (byte[])buf, (int)0);
            int offset = 4 + 4 * this.items.length;
            int start = 4;
            for (i = 0; i < this.items.length; ++i) {
                MoleculeUtils.setInt((int)offset, (byte[])buf, (int)start);
                offset += this.items[i].getSize();
                start += 4;
            }
            for (i = 0; i < this.items.length; ++i) {
                MoleculeUtils.setBytes((byte[])this.items[i].toByteArray(), (byte[])buf, (int)start);
                start += this.items[i].getSize();
            }
            SmtProofEntryVec v = new SmtProofEntryVec();
            SmtProofEntryVec.access$302(v, buf);
            SmtProofEntryVec.access$402(v, this.items);
            return v;
        }
    }
}

