/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.ckb.sign.omnilock.molecule;

import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.nervos.ckb.sign.omnilock.molecule.SmtProof;
import org.nervos.ckb.type.base.MoleculeException;
import org.nervos.ckb.type.base.MoleculeUtils;
import org.nervos.ckb.type.base.Table;

public final class SmtProofEntry
extends Table {
    public static int FIELD_COUNT = 2;
    private byte mask;
    private SmtProof proof;

    private SmtProofEntry() {
    }

    @Nonnull
    public byte getMask() {
        return this.mask;
    }

    @Nonnull
    public SmtProof getProof() {
        return this.proof;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(@Nonnull byte[] buf) {
        return new Builder(buf);
    }

    static /* synthetic */ byte[] access$302(SmtProofEntry x0, byte[] x1) {
        x0.buf = x1;
        return x1;
    }

    public static final class Builder {
        private byte mask;
        private SmtProof proof;

        private Builder() {
            this.proof = SmtProof.builder().build();
        }

        private Builder(@Nonnull byte[] buf) {
            Objects.requireNonNull(buf);
            int size = MoleculeUtils.littleEndianBytes4ToInt((byte[])buf, (int)0);
            if (buf.length != size) {
                throw MoleculeException.invalidByteSize((int)size, (int)buf.length, SmtProofEntry.class);
            }
            int[] offsets = MoleculeUtils.getOffsets((byte[])buf);
            if (offsets.length - 1 != FIELD_COUNT) {
                throw MoleculeException.invalidFieldCount((int)FIELD_COUNT, (int)(offsets.length - 1), SmtProofEntry.class);
            }
            this.mask = buf[offsets[0]];
            byte[] itemBuf = Arrays.copyOfRange(buf, offsets[1], offsets[2]);
            this.proof = SmtProof.builder(itemBuf).build();
        }

        public Builder setMask(@Nonnull byte mask) {
            Objects.requireNonNull(mask);
            this.mask = mask;
            return this;
        }

        public Builder setProof(@Nonnull SmtProof proof) {
            Objects.requireNonNull(proof);
            this.proof = proof;
            return this;
        }

        public SmtProofEntry build() {
            int i;
            int[] offsets = new int[FIELD_COUNT];
            offsets[0] = 4 + 4 * FIELD_COUNT;
            offsets[1] = offsets[0] + 1;
            int[] fieldsSize = new int[FIELD_COUNT];
            fieldsSize[0] = 1;
            fieldsSize[1] = this.proof.getSize();
            byte[][] fieldsBuf = new byte[FIELD_COUNT][];
            fieldsBuf[0] = new byte[]{this.mask};
            fieldsBuf[1] = this.proof.toByteArray();
            int size = 4 + 4 * FIELD_COUNT;
            for (int i2 = 0; i2 < FIELD_COUNT; ++i2) {
                size += fieldsSize[i2];
            }
            byte[] buf = new byte[size];
            MoleculeUtils.setInt((int)size, (byte[])buf, (int)0);
            int start = 4;
            for (i = 0; i < FIELD_COUNT; ++i) {
                MoleculeUtils.setInt((int)offsets[i], (byte[])buf, (int)start);
                start += 4;
            }
            for (i = 0; i < FIELD_COUNT; ++i) {
                MoleculeUtils.setBytes((byte[])fieldsBuf[i], (byte[])buf, (int)offsets[i]);
            }
            SmtProofEntry t = new SmtProofEntry();
            SmtProofEntry.access$302(t, buf);
            t.mask = this.mask;
            t.proof = this.proof;
            return t;
        }
    }
}

