/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.ckb.sign.omnilock;

import java.util.List;

public class OmnilockIdentity {
    private Auth identity;
    private List<SmtProofEntry> proofs;

    public Auth getIdentity() {
        return this.identity;
    }

    public void setIdentity(Auth identity) {
        this.identity = identity;
    }

    public List<SmtProofEntry> getProofs() {
        return this.proofs;
    }

    public void setProofs(List<SmtProofEntry> proofs) {
        this.proofs = proofs;
    }

    public static class Auth {
        private OmnilockFlag flag;
        private byte[] authContent;

        public OmnilockFlag getFlag() {
            return this.flag;
        }

        public void setFlag(OmnilockFlag flag) {
            this.flag = flag;
        }

        public byte[] getAuthContent() {
            return this.authContent;
        }

        public void setAuthContent(byte[] authContent) {
            this.authContent = authContent;
        }

        public byte[] encode() {
            byte[] encoded = new byte[21];
            encoded[0] = this.flag.getValue();
            System.arraycopy(this.authContent, 0, encoded, 1, 20);
            return encoded;
        }
    }

    public static enum OmnilockFlag {
        CKB_SECP256K1_BLAKE160(0),
        LOCK_SCRIPT_HASH(-4);

        private byte value;

        private OmnilockFlag(byte value) {
            this.value = value;
        }

        public byte getValue() {
            return this.value;
        }

        public static OmnilockFlag valueOf(byte flag) {
            for (OmnilockFlag omnilockFlag : OmnilockFlag.values()) {
                if (omnilockFlag.value != flag) continue;
                return omnilockFlag;
            }
            throw new IllegalArgumentException("unknown value");
        }
    }

    public static class SmtProofEntry {
        private byte mask;
        private byte[] smtProof;

        public byte getMask() {
            return this.mask;
        }

        public void setMask(byte mask) {
            this.mask = mask;
        }

        public byte[] getSmtProof() {
            return this.smtProof;
        }

        public void setSmtProof(byte[] smtProof) {
            this.smtProof = smtProof;
        }
    }
}

