/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.ckb.service.adapter;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;

public class LongTypeAdapter
implements JsonDeserializer<Long>,
JsonSerializer<Long> {
    public JsonElement serialize(Long src, Type typeOfSrc, JsonSerializationContext context) {
        return new JsonPrimitive("0x" + Long.toHexString(src));
    }

    public Long deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (json.getAsJsonPrimitive().isNumber()) {
            return json.getAsLong();
        }
        String hexValue = json.getAsString().substring(2);
        return Long.parseUnsignedLong(hexValue, 16);
    }
}

