/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.ckb.service.adapter;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

public class CheckedEnumTypeAdapterFactory
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, final TypeToken<T> type) {
        if (!type.getRawType().isEnum()) {
            return null;
        }
        final TypeAdapter delegate = gson.getDelegateAdapter((TypeAdapterFactory)this, type);
        return new TypeAdapter<T>(){

            public void write(JsonWriter out, T value) throws IOException {
                delegate.write(out, value);
            }

            public T read(JsonReader in) throws IOException {
                if (in.peek() == JsonToken.NULL) {
                    in.nextNull();
                    return null;
                }
                String rawValue = in.nextString();
                Object value = delegate.fromJsonTree((JsonElement)new JsonPrimitive(rawValue));
                if (value == null) {
                    throw new JsonParseException(String.format("Undefined value '%s' for enum '%s'", rawValue, type));
                }
                return value;
            }
        };
    }
}

