/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.ckb.service.adapter;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.math.BigInteger;

public class BigIntegerTypeAdapter
implements JsonSerializer<BigInteger>,
JsonDeserializer<BigInteger> {
    public JsonElement serialize(BigInteger src, Type typeOfSrc, JsonSerializationContext context) {
        if (src == null) {
            return null;
        }
        return new JsonPrimitive("0x" + src.toString(16));
    }

    public BigInteger deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        String hexValue = json.getAsString().substring(2);
        return new BigInteger(hexValue, 16);
    }
}

