/*
 * Decompiled with CFR 0.152.
 */
package org.kubek2k.springockito.annotations.experimental;

import java.lang.reflect.Method;
import java.util.Map;
import org.kubek2k.springockito.annotations.experimental.DirtiesMocks;
import org.kubek2k.springockito.core.internal.ResettableSpringockito;
import org.springframework.context.ApplicationContext;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.support.AbstractTestExecutionListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirtiesMocksTestContextListener
extends AbstractTestExecutionListener {
    public void afterTestMethod(TestContext testContext) throws Exception {
        Method testMethod = testContext.getTestMethod();
        Class testClass = testContext.getTestClass();
        if (testMethod.isAnnotationPresent(DirtiesMocks.class) || this.afterEveryMethodModeSet(testClass)) {
            this.resetMocks(testContext);
        }
    }

    private boolean afterEveryMethodModeSet(Class<?> testClass) {
        return testClass.isAnnotationPresent(DirtiesMocks.class) && testClass.getAnnotation(DirtiesMocks.class).classMode() == DirtiesMocks.ClassMode.AFTER_EACH_TEST_METHOD;
    }

    public void afterTestClass(TestContext testContext) throws Exception {
        Class testClass = testContext.getTestClass();
        if (this.afterClassModeSet(testClass)) {
            this.resetMocks(testContext);
        }
    }

    private boolean afterClassModeSet(Class<?> testClass) {
        return testClass.isAnnotationPresent(DirtiesMocks.class) && testClass.getAnnotation(DirtiesMocks.class).classMode() == DirtiesMocks.ClassMode.AFTER_CLASS;
    }

    private void resetMocks(TestContext testContext) {
        ApplicationContext applicationContext = testContext.getApplicationContext();
        Map beansOfType = applicationContext.getBeansOfType(ResettableSpringockito.class);
        for (ResettableSpringockito resettableSpringockito : beansOfType.values()) {
            resettableSpringockito.reset();
        }
    }
}

