/*
 * Decompiled with CFR 0.152.
 */
package org.kocakosm.jblake2;

final class LittleEndian {
    static byte[] encode(int n) {
        byte[] out = new byte[4];
        LittleEndian.encode(n, out, 0);
        return out;
    }

    static void encode(int n, byte[] out, int off) {
        out[off] = (byte)n;
        out[off + 1] = (byte)(n >>> 8);
        out[off + 2] = (byte)(n >>> 16);
        out[off + 3] = (byte)(n >>> 24);
    }

    static byte[] encode(long n) {
        byte[] out = new byte[8];
        LittleEndian.encode(n, out, 0);
        return out;
    }

    static void encode(long n, byte[] out, int off) {
        out[off] = (byte)n;
        out[off + 1] = (byte)(n >>> 8);
        out[off + 2] = (byte)(n >>> 16);
        out[off + 3] = (byte)(n >>> 24);
        out[off + 4] = (byte)(n >>> 32);
        out[off + 5] = (byte)(n >>> 40);
        out[off + 6] = (byte)(n >>> 48);
        out[off + 7] = (byte)(n >>> 56);
    }

    static int decodeInt(byte[] in) {
        return LittleEndian.decodeInt(in, 0);
    }

    static int decodeInt(byte[] in, int off) {
        return in[off] & 0xFF | (in[off + 1] & 0xFF) << 8 | (in[off + 2] & 0xFF) << 16 | (in[off + 3] & 0xFF) << 24;
    }

    static long decodeLong(byte[] in) {
        return LittleEndian.decodeLong(in, 0);
    }

    static long decodeLong(byte[] in, int off) {
        return (long)(in[off] & 0xFF) | (long)(in[off + 1] & 0xFF) << 8 | (long)(in[off + 2] & 0xFF) << 16 | (long)(in[off + 3] & 0xFF) << 24 | (long)(in[off + 4] & 0xFF) << 32 | (long)(in[off + 5] & 0xFF) << 40 | (long)(in[off + 6] & 0xFF) << 48 | (long)(in[off + 7] & 0xFF) << 56;
    }

    private LittleEndian() {
        throw new AssertionError((Object)"Not meant to be instantiated");
    }
}

