/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.artifactory.client.httpClient.http;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.jfrog.artifactory.client.httpClient.http.CloseableObserver;

public class CloseableHttpClientDecorator
extends CloseableHttpClient {
    private final CloseableHttpClient closeableHttpClient;
    private final List<CloseableObserver> closeableObservers;
    private final PoolingHttpClientConnectionManager clientConnectionManager;

    public CloseableHttpClientDecorator(CloseableHttpClient closeableHttpClient, PoolingHttpClientConnectionManager clientConnectionManager, boolean useKerberos) {
        assert (closeableHttpClient != null) : "closeableHttpClient cannot be empty";
        assert (clientConnectionManager != null) : "clientConnectionManager cannot be empty";
        this.clientConnectionManager = clientConnectionManager;
        this.closeableObservers = new ArrayList<CloseableObserver>();
        this.closeableHttpClient = closeableHttpClient;
    }

    public void close() throws IOException {
        this.onClose();
        this.closeableHttpClient.close();
    }

    protected CloseableHttpResponse doExecute(HttpHost target, HttpRequest request, HttpContext context) throws IOException {
        return this.closeableHttpClient.execute(target, request, context);
    }

    @Deprecated
    public HttpParams getParams() {
        return this.closeableHttpClient.getParams();
    }

    @Deprecated
    public ClientConnectionManager getConnectionManager() {
        return this.closeableHttpClient.getConnectionManager();
    }

    public void onClose() {
        for (CloseableObserver closeableObserver : this.closeableObservers) {
            closeableObserver.onObservedClose((Object)this);
        }
    }
}

