/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.artifactory.client.httpClient.http.auth;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.AuthState;
import org.apache.http.auth.Credentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.HttpRequestWrapper;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.protocol.HttpContext;

public class PreemptiveAuthInterceptor
implements HttpRequestInterceptor {
    public static final String ORIGINAL_HOST_CONTEXT_PARAM = "original.host.context.param";

    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        if (!this.shouldSetAuthScheme(request, context)) {
            return;
        }
        HttpClientContext clientContext = HttpClientContext.adapt((HttpContext)context);
        AuthState authState = clientContext.getTargetAuthState();
        if (authState.getAuthScheme() == null) {
            String accessToken = (String)clientContext.getUserToken(String.class);
            if (StringUtils.isNotEmpty((CharSequence)accessToken)) {
                request.addHeader("Authorization", "Bearer " + accessToken);
            } else {
                HttpHost targetHost;
                CredentialsProvider credsProvider = clientContext.getCredentialsProvider();
                Credentials creds = credsProvider.getCredentials(new AuthScope((targetHost = clientContext.getTargetHost()).getHostName(), targetHost.getPort()));
                if (creds != null) {
                    authState.update((AuthScheme)new BasicScheme(), creds);
                }
            }
        }
    }

    private boolean shouldSetAuthScheme(HttpRequest request, HttpContext context) {
        String host;
        String originalHost = (String)context.getAttribute(ORIGINAL_HOST_CONTEXT_PARAM);
        if (originalHost == null) {
            return true;
        }
        try {
            host = new URI(((HttpRequestWrapper)request).getOriginal().getRequestLine().getUri()).getHost();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        return host.equals(originalHost);
    }
}

