/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.artifactory.client.httpClient.http;

import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.conn.SchemePortResolver;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.impl.conn.DefaultRoutePlanner;
import org.apache.http.impl.conn.DefaultSchemePortResolver;
import org.apache.http.protocol.HttpContext;
import org.jfrog.artifactory.client.httpClient.http.NoProxyHostsEvaluator;
import org.jfrog.artifactory.client.httpClient.http.ProxyProvider;

public class DefaultHostSpecificProxyRoutePlanner
extends DefaultRoutePlanner {
    private final HttpHost defaultHost;
    private final ProxyProvider proxyProvider;
    private final NoProxyHostsEvaluator noProxyHostsEvaluator;

    private DefaultHostSpecificProxyRoutePlanner(HttpHost defaultHost, ProxyProvider proxyProvider, String noProxyHosts) {
        super((SchemePortResolver)DefaultSchemePortResolver.INSTANCE);
        this.defaultHost = defaultHost;
        this.proxyProvider = proxyProvider;
        this.noProxyHostsEvaluator = new NoProxyHostsEvaluator(noProxyHosts);
    }

    public HttpRoute determineRoute(HttpHost host, HttpRequest request, HttpContext context) throws HttpException {
        if (host == null) {
            host = this.defaultHost;
        }
        return super.determineRoute(host, request, context);
    }

    protected HttpHost determineProxy(HttpHost target, HttpRequest request, HttpContext context) {
        HttpHost proxy = this.proxyProvider.getProxy();
        if (proxy != null && (this.isTargetLocalhost(target) || this.noProxyHostsEvaluator.shouldBypassProxy(target.toHostString()))) {
            return null;
        }
        return proxy;
    }

    public HttpHost getDefaultHost() {
        return this.defaultHost;
    }

    public HttpHost getProxy() {
        return this.proxyProvider.getProxy();
    }

    public String getNoProxyHosts() {
        return this.noProxyHostsEvaluator.getNoProxyHosts();
    }

    private boolean isTargetLocalhost(HttpHost target) {
        return target.getHostName().equalsIgnoreCase("localhost") || target.getHostName().equals("127.0.0.1");
    }

    public static class Builder {
        private HttpHost defaultHost;
        private ProxyProvider proxyProvider = () -> null;
        private String noProxyHosts;

        public Builder defaultHost(HttpHost defaultHost) {
            this.defaultHost = defaultHost;
            return this;
        }

        public Builder proxyProvider(ProxyProvider proxyProvider) {
            this.proxyProvider = proxyProvider;
            return this;
        }

        public Builder noProxyHosts(String noProxyHosts) {
            this.noProxyHosts = noProxyHosts;
            return this;
        }

        public DefaultHostSpecificProxyRoutePlanner build() {
            return new DefaultHostSpecificProxyRoutePlanner(this.defaultHost, this.proxyProvider, this.noProxyHosts);
        }
    }
}

