/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.lombok.config;

import java.io.File;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.lombok.config.ConfigParser;
import org.jetbrains.kotlin.lombok.config.LombokConfigKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u001f\u0012\u0018\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\u0015\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\nJ\u0016\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00052\u0006\u0010\t\u001a\u00020\u0004J\u0010\u0010\f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\t\u001a\u00020\u0004J\u0018\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00052\u0006\u0010\t\u001a\u00020\u0004H\u0002R \u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/lombok/config/LombokConfig;", "", "config", "", "", "", "(Ljava/util/Map;)V", "getBoolean", "", "key", "(Ljava/lang/String;)Ljava/lang/Boolean;", "getMultiString", "getString", "getValue", "Companion", "kotlin-maven-lombok"})
public final class LombokConfig {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, List<String>> config;
    @NotNull
    private static final LombokConfig Empty = new LombokConfig(MapsKt.emptyMap());

    public LombokConfig(@NotNull Map<String, ? extends List<String>> config) {
        Intrinsics.checkNotNullParameter(config, (String)"config");
        this.config = config;
    }

    @Nullable
    public final String getString(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        List<String> list = this.getValue(key);
        return list != null ? (String)CollectionsKt.firstOrNull(list) : null;
    }

    @Nullable
    public final Boolean getBoolean(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        String string = this.getString(key);
        return string != null ? Boolean.valueOf(Boolean.parseBoolean(string)) : null;
    }

    @Nullable
    public final List<String> getMultiString(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.getValue(key);
    }

    private final List<String> getValue(String key) {
        return this.config.get(LombokConfigKt.access$normalizeKey(key));
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/lombok/config/LombokConfig$Companion;", "", "()V", "Empty", "Lorg/jetbrains/kotlin/lombok/config/LombokConfig;", "getEmpty", "()Lorg/jetbrains/kotlin/lombok/config/LombokConfig;", "parse", "path", "Ljava/io/File;", "kotlin-maven-lombok"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LombokConfig getEmpty() {
            return Empty;
        }

        @NotNull
        public final LombokConfig parse(@NotNull File path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            return ConfigParser.INSTANCE.parse(path);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

