/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.utils.bean;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import org.javasimon.utils.bean.BeanUtilsException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ClassUtils {
    private static final Logger logger = LoggerFactory.getLogger(ClassUtils.class);

    private ClassUtils() {
        throw new AssertionError((Object)"ClassUtils is a collections of utility methods");
    }

    static Field getField(Class<?> targetClass, String fieldName) {
        while (targetClass != null) {
            try {
                Field field = targetClass.getDeclaredField(fieldName);
                logger.debug("Found field {} in class {}", (Object)fieldName, (Object)targetClass.getName());
                return field;
            }
            catch (NoSuchFieldException e) {
                logger.debug("Failed to find field {} in class {}", (Object)fieldName, (Object)targetClass.getName());
                targetClass = targetClass.getSuperclass();
            }
        }
        return null;
    }

    static Method getSetter(Class<?> targetClass, String propertyName, Class<?> type) {
        String setterMethodName = ClassUtils.setterName(propertyName);
        while (targetClass != null) {
            try {
                Method setter = targetClass.getDeclaredMethod(setterMethodName, type);
                logger.debug("Found setter {} in class {}", (Object)setterMethodName, (Object)targetClass.getName());
                return setter;
            }
            catch (NoSuchMethodException e) {
                logger.debug("Failed to found setter {} in class {}", (Object)setterMethodName, (Object)targetClass.getName());
                targetClass = targetClass.getSuperclass();
            }
        }
        return null;
    }

    private static String setterName(String name) {
        return "set" + name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    static Set<Method> getSetters(Class<?> targetClass, String propertyName) {
        String setterName = ClassUtils.setterName(propertyName);
        HashSet<Method> setters = new HashSet<Method>();
        while (targetClass != null) {
            for (Method method : targetClass.getDeclaredMethods()) {
                if (!method.getName().equals(setterName) || method.getParameterTypes().length != 1) continue;
                logger.debug("Found setter {} in class {}", (Object)method, targetClass);
                setters.add(method);
            }
            targetClass = targetClass.getSuperclass();
        }
        return setters;
    }

    static Class<?> getSetterType(Method setter) {
        Class<?>[] parameterTypes = setter.getParameterTypes();
        if (parameterTypes.length != 1) {
            throw new BeanUtilsException(String.format("Method %s has %d parameters and cannot be a setter", setter.getName(), parameterTypes.length));
        }
        return parameterTypes[0];
    }

    static Method getGetter(Class<?> targetClass, String propertyName) {
        String getterName = ClassUtils.getterName(propertyName);
        while (targetClass != null) {
            try {
                Method getter = targetClass.getDeclaredMethod(getterName, new Class[0]);
                logger.debug("Found getter {} in class {}", (Object)getter.getName(), (Object)targetClass.getName());
                return getter;
            }
            catch (NoSuchMethodException e) {
                logger.debug("Failed  to find getter for property {} in class {}", (Object)propertyName, (Object)targetClass.getName());
                targetClass = targetClass.getSuperclass();
            }
        }
        return null;
    }

    private static String getterName(String propertyName) {
        return "get" + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
    }
}

