/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.utils;

import org.javasimon.Counter;
import org.javasimon.CounterSample;
import org.javasimon.Simon;
import org.javasimon.Split;
import org.javasimon.Stopwatch;
import org.javasimon.StopwatchSample;
import org.javasimon.callback.CallbackSkeleton;

public final class SystemDebugCallback
extends CallbackSkeleton {
    public static final String DEBUG_PREFIX = "SIMON DEBUG: ";

    public void onSimonReset(Simon simon) {
        this.out("Simon reset: " + simon);
    }

    public void onStopwatchStart(Split split) {
        this.out("Start split: " + split);
    }

    public void onStopwatchStop(Split split, StopwatchSample sample) {
        this.out("Stopwatch stop (" + split + "): " + sample.simonToString());
    }

    public void onStopwatchAdd(Stopwatch stopwatch, Split split, StopwatchSample sample) {
        this.out("Stopwatch add (" + split + "): " + sample.simonToString());
    }

    public void onCounterDecrease(Counter counter, long dec, CounterSample sample) {
        this.out("Counter decrease: " + sample.simonToString());
    }

    public void onCounterIncrease(Counter counter, long inc, CounterSample sample) {
        this.out("Counter increase: " + sample.simonToString());
    }

    public void onCounterSet(Counter counter, long val, CounterSample sample) {
        this.out("Counter set: " + sample.simonToString());
    }

    public void onSimonCreated(Simon simon) {
        this.out("Simon created: " + simon);
    }

    public void onSimonDestroyed(Simon simon) {
        this.out("Simon destroyed: " + simon);
    }

    public void onManagerClear() {
        this.out("Manager clear");
    }

    public void onManagerMessage(String message) {
        this.out("Simon message: " + message);
    }

    private void out(String message) {
        System.out.println(DEBUG_PREFIX + message);
    }

    public void onManagerWarning(String warning, Exception cause) {
        if (warning != null) {
            System.err.println("SIMON DEBUG: Simon warning: " + warning);
        }
        if (cause != null) {
            System.err.print(DEBUG_PREFIX);
            cause.printStackTrace();
        }
    }
}

