/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.callback.calltree;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.javasimon.Split;
import org.javasimon.utils.SimonUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CallTreeNode {
    private final String name;
    private final List<Split> splits = new ArrayList<Split>(1);
    private Map<String, CallTreeNode> children;
    private CallTreeNode parent;

    public CallTreeNode(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void addSplit(Split split) {
        this.splits.add(split);
    }

    public int getSplitCount() {
        return this.splits.size();
    }

    public long getTotal() {
        long total = 0L;
        for (Split split : this.splits) {
            total += split.runningFor();
        }
        return total;
    }

    public Integer getPercent() {
        Integer percent = this.parent == null ? null : Integer.valueOf((int)(this.getTotal() * 100L / this.getParent().getTotal()));
        return percent;
    }

    public CallTreeNode addChild(String name) {
        if (this.children == null) {
            this.children = new HashMap<String, CallTreeNode>();
        }
        CallTreeNode child = new CallTreeNode(name);
        this.children.put(name, child);
        child.parent = this;
        return child;
    }

    public CallTreeNode getChild(String name) {
        return this.children == null ? null : this.children.get(name);
    }

    public Collection<CallTreeNode> getChildren() {
        return this.children == null ? Collections.emptyList() : this.children.values();
    }

    public CallTreeNode getOrAddChild(String name) {
        CallTreeNode child = this.getChild(name);
        if (child == null) {
            child = this.addChild(name);
        }
        return child;
    }

    public CallTreeNode getParent() {
        return this.parent;
    }

    private void print(PrintWriter printWriter, String prefix, Long parentTotal) {
        long total = this.getTotal();
        printWriter.print(prefix);
        printWriter.print(this.name);
        printWriter.print(' ');
        if (parentTotal != null && parentTotal != 0L) {
            printWriter.print(total * 100L / parentTotal);
            printWriter.print("%, ");
        }
        printWriter.print(SimonUtils.presentNanoTime(total));
        long counter = this.getSplitCount();
        if (counter > 1L) {
            printWriter.print(", ");
            printWriter.print(counter);
        }
        printWriter.println();
        for (CallTreeNode child : this.getChildren()) {
            child.print(printWriter, prefix + "\t", total);
        }
    }

    public void print(PrintWriter printWriter) {
        this.print(printWriter, "", null);
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        this.print(printWriter);
        return stringWriter.toString();
    }
}

