/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.javasimon.EnabledManager;
import org.javasimon.Manager;
import org.javasimon.SwitchingManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IncrementalSimonsPurger {
    private final Manager manager;
    private final ScheduledExecutorService executorService;
    private ScheduledFuture<?> scheduledFuture;

    public IncrementalSimonsPurger(Manager manager) {
        this(manager, IncrementalSimonsPurger.createExecutorService());
    }

    IncrementalSimonsPurger(Manager manager, ScheduledExecutorService executorService) {
        this.manager = manager;
        this.executorService = executorService;
    }

    private static ScheduledExecutorService createExecutorService() {
        DaemonThreadFactory threadFactory = new DaemonThreadFactory();
        return Executors.newSingleThreadScheduledExecutor(threadFactory);
    }

    public synchronized void start(long period, TimeUnit timeUnit) {
        if (this.scheduledFuture != null) {
            throw new IllegalStateException("IncrementSimonPurger has already been started");
        }
        PurgerRunnable runnable = new PurgerRunnable(this.manager);
        this.scheduledFuture = this.executorService.scheduleWithFixedDelay(runnable, period, period, timeUnit);
    }

    public synchronized void cancel() {
        if (this.scheduledFuture == null) {
            throw new IllegalStateException("IncrementSimonPurger is either cancelled or was not started");
        }
        this.scheduledFuture.cancel(false);
        this.scheduledFuture = null;
    }

    static class DaemonThreadFactory
    implements ThreadFactory {
        private int threadNumber;

        DaemonThreadFactory() {
        }

        public synchronized Thread newThread(Runnable runnable) {
            Thread daemonThread = new Thread(runnable);
            daemonThread.setDaemon(true);
            daemonThread.setName("javasimon-simonsPurger-" + ++this.threadNumber);
            return daemonThread;
        }
    }

    static class PurgerRunnable
    implements Runnable {
        private static final Logger logger = LoggerFactory.getLogger(PurgerRunnable.class);
        private Manager manager;
        private long periodStartMs;

        public PurgerRunnable(Manager manager) {
            this(manager, manager.milliTime());
        }

        PurgerRunnable(Manager manager, long periodStartMs) {
            this.manager = manager;
            this.periodStartMs = periodStartMs;
        }

        public void run() {
            logger.debug("Purging old incremental Simons");
            if (this.manager instanceof EnabledManager) {
                ((EnabledManager)this.manager).purgeIncrementalSimonsOlderThan(this.periodStartMs);
            } else if (this.manager instanceof SwitchingManager) {
                ((SwitchingManager)this.manager).purgeIncrementalSimonsOlderThan(this.periodStartMs);
            }
            this.periodStartMs = this.manager.milliTime();
        }

        Manager getManager() {
            return this.manager;
        }
    }
}

