/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.derby;

import java.sql.SQLException;
import org.flywaydb.core.api.configuration.FlywayConfiguration;
import org.flywaydb.core.internal.database.Connection;
import org.flywaydb.core.internal.database.Database;
import org.flywaydb.core.internal.database.SqlStatementBuilder;
import org.flywaydb.core.internal.database.derby.DerbyConnection;
import org.flywaydb.core.internal.database.derby.DerbySqlStatementBuilder;
import org.flywaydb.core.internal.exception.FlywayDbUpgradeRequiredException;

public class DerbyDatabase
extends Database {
    public DerbyDatabase(FlywayConfiguration configuration, java.sql.Connection connection) {
        super(configuration, connection, 12);
    }

    protected Connection getConnection(java.sql.Connection connection, int nullType) {
        return new DerbyConnection(this.configuration, this, connection, nullType);
    }

    @Override
    protected final void ensureSupported() {
        String version = this.majorVersion + "." + this.minorVersion;
        if (this.majorVersion < 10 || this.majorVersion == 10 && this.minorVersion < 8) {
            throw new FlywayDbUpgradeRequiredException("Derby", version, "10.8.1.2");
        }
    }

    @Override
    public String getDbName() {
        return "derby";
    }

    @Override
    protected String doGetCurrentUser() throws SQLException {
        return this.mainConnection.getJdbcTemplate().queryForString("SELECT CURRENT_USER FROM SYSIBM.SYSDUMMY1", new String[0]);
    }

    @Override
    public boolean supportsDdlTransactions() {
        return true;
    }

    @Override
    public String getBooleanTrue() {
        return "true";
    }

    @Override
    public String getBooleanFalse() {
        return "false";
    }

    @Override
    public SqlStatementBuilder createSqlStatementBuilder() {
        return new DerbySqlStatementBuilder(this.getDefaultDelimiter());
    }

    @Override
    public String doQuote(String identifier) {
        return "\"" + identifier + "\"";
    }

    @Override
    public boolean catalogIsSchema() {
        return false;
    }

    @Override
    public boolean useSingleConnection() {
        return true;
    }
}

