/*
 * Decompiled with CFR 0.152.
 */
package com.firestack.laksaj.utils;

import com.firestack.laksaj.proto.Message;
import com.firestack.laksaj.transaction.TxParams;
import com.firestack.laksaj.utils.ByteUtil;
import com.google.common.base.Strings;
import com.google.protobuf.ByteString;
import java.math.BigInteger;
import org.bouncycastle.util.BigIntegers;

public class TransactionUtil {
    public byte[] encodeTransactionProto(TxParams txParams) {
        BigInteger amount = new BigInteger(txParams.getAmount());
        BigInteger gasPrice = new BigInteger(txParams.getGasPrice());
        Message.ProtoTransactionCoreInfo.Builder builder = Message.ProtoTransactionCoreInfo.newBuilder().setVersion(Integer.valueOf(txParams.getVersion())).setNonce(Strings.isNullOrEmpty((String)txParams.getNonce()) ? 0L : Long.valueOf(txParams.getNonce())).setToaddr(ByteString.copyFrom((byte[])ByteUtil.hexStringToByteArray(txParams.getToAddr().toLowerCase()))).setSenderpubkey(Message.ByteArray.newBuilder().setData(ByteString.copyFrom((byte[])ByteUtil.hexStringToByteArray(txParams.getSenderPubKey()))).build()).setAmount(Message.ByteArray.newBuilder().setData(ByteString.copyFrom((byte[])BigIntegers.asUnsignedByteArray((int)16, (BigInteger)amount))).build()).setGasprice(Message.ByteArray.newBuilder().setData(ByteString.copyFrom((byte[])BigIntegers.asUnsignedByteArray((int)16, (BigInteger)gasPrice))).build()).setGaslimit(Long.valueOf(txParams.getGasLimit()));
        if (null != txParams.getCode() && !txParams.getCode().isEmpty()) {
            builder.setCode(ByteString.copyFrom((byte[])txParams.getCode().getBytes()));
        }
        if (null != txParams.getData() && !txParams.getData().isEmpty()) {
            builder.setData(ByteString.copyFrom((byte[])txParams.getData().getBytes()));
        }
        return builder.build().toByteArray();
    }
}

