/*
 * Decompiled with CFR 0.152.
 */
package com.firestack.laksaj.crypto;

import com.firestack.laksaj.crypto.KDFParams;

public class ScryptParams
implements KDFParams {
    private String salt;
    private int dkLen;
    private int n;
    private int r;
    private int p;

    ScryptParams(String salt, int dkLen, int n, int r, int p) {
        this.salt = salt;
        this.dkLen = dkLen;
        this.n = n;
        this.r = r;
        this.p = p;
    }

    public static ScryptParamsBuilder builder() {
        return new ScryptParamsBuilder();
    }

    public String getSalt() {
        return this.salt;
    }

    public int getDkLen() {
        return this.dkLen;
    }

    public int getN() {
        return this.n;
    }

    public int getR() {
        return this.r;
    }

    public int getP() {
        return this.p;
    }

    public void setSalt(String salt) {
        this.salt = salt;
    }

    public void setDkLen(int dkLen) {
        this.dkLen = dkLen;
    }

    public void setN(int n) {
        this.n = n;
    }

    public void setR(int r) {
        this.r = r;
    }

    public void setP(int p) {
        this.p = p;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ScryptParams)) {
            return false;
        }
        ScryptParams other = (ScryptParams)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$salt = this.getSalt();
        String other$salt = other.getSalt();
        if (this$salt == null ? other$salt != null : !this$salt.equals(other$salt)) {
            return false;
        }
        if (this.getDkLen() != other.getDkLen()) {
            return false;
        }
        if (this.getN() != other.getN()) {
            return false;
        }
        if (this.getR() != other.getR()) {
            return false;
        }
        return this.getP() == other.getP();
    }

    protected boolean canEqual(Object other) {
        return other instanceof ScryptParams;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $salt = this.getSalt();
        result = result * 59 + ($salt == null ? 43 : $salt.hashCode());
        result = result * 59 + this.getDkLen();
        result = result * 59 + this.getN();
        result = result * 59 + this.getR();
        result = result * 59 + this.getP();
        return result;
    }

    public String toString() {
        return "ScryptParams(salt=" + this.getSalt() + ", dkLen=" + this.getDkLen() + ", n=" + this.getN() + ", r=" + this.getR() + ", p=" + this.getP() + ")";
    }

    public static class ScryptParamsBuilder {
        private String salt;
        private int dkLen;
        private int n;
        private int r;
        private int p;

        ScryptParamsBuilder() {
        }

        public ScryptParamsBuilder salt(String salt) {
            this.salt = salt;
            return this;
        }

        public ScryptParamsBuilder dkLen(int dkLen) {
            this.dkLen = dkLen;
            return this;
        }

        public ScryptParamsBuilder n(int n) {
            this.n = n;
            return this;
        }

        public ScryptParamsBuilder r(int r) {
            this.r = r;
            return this;
        }

        public ScryptParamsBuilder p(int p) {
            this.p = p;
            return this;
        }

        public ScryptParams build() {
            return new ScryptParams(this.salt, this.dkLen, this.n, this.r, this.p);
        }

        public String toString() {
            return "ScryptParams.ScryptParamsBuilder(salt=" + this.salt + ", dkLen=" + this.dkLen + ", n=" + this.n + ", r=" + this.r + ", p=" + this.p + ")";
        }
    }
}

