/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import org.fest.assertions.Formatting;
import org.fest.assertions.GroupAssert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringAssert
extends GroupAssert<StringAssert, String> {
    protected StringAssert(String actual) {
        super(StringAssert.class, actual);
    }

    public StringAssert isEqualToIgnoringCase(String expected) {
        if (this.actual == null && expected == null) {
            return this;
        }
        this.isNotNull();
        if (((String)this.actual).equalsIgnoreCase(expected)) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(Formatting.format("<%s> should be equal to :<%s> ignoring case", this.actual, expected));
    }

    @Override
    protected int actualGroupSize() {
        this.isNotNull();
        return ((String)this.actual).length();
    }

    public StringAssert contains(String expected) {
        this.isNotNull();
        if (((String)this.actual).indexOf(expected) != -1) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(Formatting.format("<%s> should contain the String:<%s>", this.actual, expected));
    }

    public StringAssert endsWith(String expected) {
        this.isNotNull();
        if (((String)this.actual).endsWith(expected)) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(Formatting.format("<%s> should end with:<%s>", this.actual, expected));
    }

    public StringAssert startsWith(String expected) {
        this.isNotNull();
        if (((String)this.actual).startsWith(expected)) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(Formatting.format("<%s> should start with:<%s>", this.actual, expected));
    }

    public StringAssert excludes(String s) {
        this.isNotNull();
        if (((String)this.actual).indexOf(s) == -1) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(Formatting.format("<%s> should not contain the String:<%s>", this.actual, s));
    }

    public StringAssert matches(String regex) {
        this.isNotNull();
        if (((String)this.actual).matches(regex)) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(Formatting.format("<%s> should match the regular expression:<%s>", this.actual, regex));
    }

    public StringAssert doesNotMatch(String regex) {
        this.isNotNull();
        if (!((String)this.actual).matches(regex)) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(Formatting.format("<%s> should not match the regular expression:<%s>", this.actual, regex));
    }

    public StringAssert containsIgnoringCase(String text) {
        StringAssert.validateNotNull(text);
        this.isNotNull();
        if (((String)this.actual).toLowerCase().contains(text.toLowerCase())) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(Formatting.format("<%s> does not contain <%s>", this.actual, text));
    }

    public StringAssert doesNotContain(String text) {
        StringAssert.validateNotNull(text);
        this.isNotNull();
        if (!((String)this.actual).contains(text)) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(Formatting.format("<%s> should not contain <%s>", this.actual, text));
    }

    private static void validateNotNull(String text) {
        if (text == null) {
            throw new NullPointerException("The given String should not be null");
        }
    }
}

