/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.modes;

import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.PacketCipher;
import org.bouncycastle.crypto.params.AEADParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;

public interface AESCCMModePacketCipher
extends PacketCipher {
    default public int getMacSize(boolean bl, CipherParameters cipherParameters) {
        byte[] byArray;
        KeyParameter keyParameter;
        int n;
        CipherParameters cipherParameters2;
        if (cipherParameters instanceof AEADParameters) {
            cipherParameters2 = (AEADParameters)cipherParameters;
            n = this.getCCMMacSize(bl, ((AEADParameters)cipherParameters2).getMacSize());
            keyParameter = ((AEADParameters)cipherParameters2).getKey();
            byArray = ((AEADParameters)cipherParameters2).getNonce();
        } else if (cipherParameters instanceof ParametersWithIV) {
            cipherParameters2 = (ParametersWithIV)cipherParameters;
            n = 8;
            keyParameter = (KeyParameter)((ParametersWithIV)cipherParameters2).getParameters();
            byArray = ((ParametersWithIV)cipherParameters2).getIV();
        } else {
            throw new IllegalArgumentException("invalid parameters passed to CCM");
        }
        if (byArray == null || byArray.length < 7 || byArray.length > 13) {
            throw new IllegalArgumentException("nonce must have length from 7 to 13 octets");
        }
        if (keyParameter != null) {
            int n2 = keyParameter.getKeyLength();
            if (n2 < 16 || n2 > 32 || (n2 & 7) != 0) {
                throw new IllegalArgumentException("key must be only 16, 24 or 32 bytes long");
            }
        } else {
            throw new IllegalArgumentException("CCM cipher unitialized");
        }
        return n;
    }

    default public int getCCMMacSize(boolean bl, int n) {
        if (bl && (n < 32 || n > 128 || 0 != (n & 0xF))) {
            throw new IllegalArgumentException("tag length in octets must be one of {4,6,8,10,12,14,16}");
        }
        return n >>> 3;
    }
}

