/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.engines;

import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.MultiBlockCipher;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.modes.CBCModeCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.dispose.NativeDisposer;
import org.bouncycastle.util.dispose.NativeReference;

class AESNativeCBC
implements CBCModeCipher {
    private CBCRefWrapper referenceWrapper;
    byte[] IV = new byte[16];
    byte[] oldKey;
    int keySize;
    private boolean encrypting;

    AESNativeCBC() {
    }

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) throws IllegalArgumentException {
        boolean bl2 = this.encrypting;
        this.encrypting = bl;
        if (cipherParameters instanceof ParametersWithIV) {
            ParametersWithIV parametersWithIV = (ParametersWithIV)cipherParameters;
            byte[] byArray = parametersWithIV.getIV();
            if (byArray.length != this.getBlockSize()) {
                throw new IllegalArgumentException("initialisation vector must be the same length as block size");
            }
            System.arraycopy(byArray, 0, this.IV, 0, byArray.length);
            this.reset();
            if (parametersWithIV.getParameters() != null) {
                this.init((KeyParameter)parametersWithIV.getParameters());
            } else {
                if (bl2 != this.encrypting) {
                    throw new IllegalArgumentException("cannot change encrypting state without providing key");
                }
                if (this.oldKey == null) {
                    throw new IllegalStateException("IV change attempted but not previously initialized with a key");
                }
                this.init(new KeyParameter(this.oldKey));
            }
        } else {
            this.reset();
            if (cipherParameters != null) {
                this.init((KeyParameter)cipherParameters);
            } else {
                if (bl2 != this.encrypting) {
                    throw new IllegalArgumentException("cannot change encrypting state without providing key.");
                }
                if (this.oldKey == null) {
                    throw new IllegalStateException("IV change attempted but not previously initialized with a key");
                }
                this.init(new KeyParameter(this.oldKey));
            }
        }
    }

    private void init(KeyParameter keyParameter) {
        byte[] byArray = keyParameter.getKey();
        switch (byArray.length) {
            case 16: 
            case 24: 
            case 32: {
                break;
            }
            default: {
                throw new IllegalArgumentException("key must be only 16,24,or 32 bytes long.");
            }
        }
        this.referenceWrapper = new CBCRefWrapper(AESNativeCBC.makeNative(byArray.length, this.encrypting));
        if (this.referenceWrapper.getReference() == 0L) {
            throw new IllegalStateException("Native CBC native instance returned a null pointer.");
        }
        this.oldKey = Arrays.clone(byArray);
        this.init(this.referenceWrapper.getReference(), byArray, this.IV);
        this.keySize = byArray.length * 8;
    }

    @Override
    public String getAlgorithmName() {
        return "AES/CBC";
    }

    @Override
    public int getBlockSize() {
        return AESNativeCBC.getBlockSize(0L);
    }

    @Override
    public int processBlock(byte[] byArray, int n, byte[] byArray2, int n2) throws DataLengthException, IllegalStateException {
        if (this.referenceWrapper == null) {
            throw new IllegalStateException("not initialized");
        }
        return AESNativeCBC.process(this.referenceWrapper.getReference(), byArray, n, 1, byArray2, n2);
    }

    @Override
    public void reset() {
        if (this.referenceWrapper == null) {
            return;
        }
        AESNativeCBC.reset(this.referenceWrapper.getReference());
    }

    @Override
    public int getMultiBlockSize() {
        return AESNativeCBC.getMultiBlockSize(0L);
    }

    @Override
    public int processBlocks(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws DataLengthException, IllegalStateException {
        if (this.referenceWrapper == null) {
            throw new IllegalStateException("not initialized");
        }
        return AESNativeCBC.process(this.referenceWrapper.getReference(), byArray, n, n2, byArray2, n3);
    }

    private static native int process(long var0, byte[] var2, int var3, int var4, byte[] var5, int var6);

    private static native int getMultiBlockSize(long var0);

    private static native int getBlockSize(long var0);

    static native long makeNative(int var0, boolean var1);

    native void init(long var1, byte[] var3, byte[] var4);

    static native void dispose(long var0);

    private static native void reset(long var0);

    @Override
    public BlockCipher getUnderlyingCipher() {
        MultiBlockCipher multiBlockCipher = AESEngine.newInstance();
        multiBlockCipher.init(this.encrypting, new KeyParameter(this.oldKey));
        return multiBlockCipher;
    }

    public String toString() {
        return "CBC[Native](AES[Native](" + this.keySize + ")";
    }

    private class CBCRefWrapper
    extends NativeReference {
        public CBCRefWrapper(long l) {
            super(l, "CBC");
        }

        @Override
        public Runnable createAction() {
            return new Disposer(this.reference);
        }
    }

    private class Disposer
    extends NativeDisposer {
        Disposer(long l) {
            super(l);
        }

        @Override
        protected void dispose(long l) {
            Arrays.clear(AESNativeCBC.this.oldKey);
            Arrays.clear(AESNativeCBC.this.IV);
            AESNativeCBC.dispose(l);
        }
    }
}

