/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.FileExistsException;

public class FileUtils {
    public static File resolvePath(File base, String path) {
        File r = new File(path);
        return r.isAbsolute() ? r : new File(base, path);
    }

    public static void copyFile(File src, File destination) throws IOException {
        try (FileChannel in = new FileInputStream(src).getChannel();
             FileChannel out = new FileOutputStream(destination).getChannel();){
            in.transferTo(0L, in.size(), out);
        }
    }

    public static void sync(File fullFile) throws IOException {
        if (fullFile == null || !fullFile.exists()) {
            throw new FileNotFoundException("File does not exist " + fullFile);
        }
        boolean success = false;
        int retryCount = 0;
        IOException exc = null;
        while (!success && retryCount < 5) {
            ++retryCount;
            try (RandomAccessFile file = new RandomAccessFile(fullFile, "rw");){
                file.getFD().sync();
                success = true;
            }
            catch (IOException ioe) {
                if (exc == null) {
                    exc = ioe;
                }
                try {
                    Thread.sleep(5L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        if (!success) {
            throw exc;
        }
    }

    public static boolean fileExists(String filePathString) {
        return new File(filePathString).exists();
    }

    public static Path createDirectories(Path path) throws IOException {
        if (Files.exists(path, new LinkOption[0]) && Files.isSymbolicLink(path)) {
            Path real = path.toRealPath(new LinkOption[0]);
            if (Files.isDirectory(real, new LinkOption[0])) {
                return real;
            }
            throw new FileExistsException("Tried to create a directory at to an existing non-directory symlink: " + path.toString());
        }
        return Files.createDirectories(path, new FileAttribute[0]);
    }

    public static boolean isPathAChildOfParent(Path parent, Path potentialChild) {
        Path normalizedParent = parent.toAbsolutePath().normalize();
        Path normalizedChild = potentialChild.toAbsolutePath().normalize();
        return normalizedChild.startsWith(normalizedParent) && !normalizedChild.equals(normalizedParent);
    }
}

