/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cli;

import java.io.PrintStream;
import org.apache.commons.cli.CommandLine;
import org.apache.solr.cli.CLIO;
import org.apache.solr.cli.SolrCLI;
import org.apache.solr.cli.Tool;

public abstract class ToolBase
implements Tool {
    protected PrintStream stdout;
    protected boolean verbose = false;

    protected ToolBase() {
        this(CLIO.getOutStream());
    }

    protected ToolBase(PrintStream stdout) {
        this.stdout = stdout;
    }

    protected void echoIfVerbose(String msg, CommandLine cli) {
        if (this.verbose) {
            this.echo(msg);
        }
    }

    protected boolean isVerbose() {
        return this.verbose;
    }

    protected void echo(String msg) {
        this.stdout.println(msg);
    }

    @Override
    public int runTool(CommandLine cli) throws Exception {
        this.verbose = cli.hasOption(SolrCLI.OPTION_VERBOSE.getLongOpt()) || cli.hasOption(SolrCLI.OPTION_VERBOSE_DEPRECATED);
        int toolExitStatus = 0;
        try {
            this.runImpl(cli);
        }
        catch (Exception exc) {
            String excMsg = exc.getMessage();
            if (excMsg != null) {
                CLIO.err("\nERROR: " + excMsg + "\n");
                if (this.verbose) {
                    exc.printStackTrace(CLIO.getErrStream());
                }
                toolExitStatus = 1;
            }
            throw exc;
        }
        return toolExitStatus;
    }

    public abstract void runImpl(CommandLine var1) throws Exception;
}

