/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update.processor;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import org.apache.solr.common.SolrInputField;
import org.apache.solr.update.processor.FieldMutatingUpdateProcessor;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AllValuesOrNoneFieldMutatingUpdateProcessor
extends FieldMutatingUpdateProcessor {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final Object DELETE_VALUE_SINGLETON = new Object(){

        public String toString() {
            return "!!Singleton Object Triggering Value Deletion!!";
        }
    };
    public static final Object SKIP_FIELD_VALUE_LIST_SINGLETON = new Object(){

        public String toString() {
            return "!!Singleton Object Triggering Skipping Field Mutation!!";
        }
    };

    public AllValuesOrNoneFieldMutatingUpdateProcessor(FieldMutatingUpdateProcessor.FieldNameSelector selector, UpdateRequestProcessor next) {
        super(selector, next);
    }

    protected abstract Object mutateValue(Object var1);

    @Override
    protected final SolrInputField mutate(SolrInputField srcField) {
        Collection vals = srcField.getValues();
        if (vals == null || vals.isEmpty()) {
            return srcField;
        }
        ArrayList<String> messages = null;
        SolrInputField result = new SolrInputField(srcField.getName());
        for (Object srcVal : vals) {
            Object destVal = this.mutateValue(srcVal);
            if (SKIP_FIELD_VALUE_LIST_SINGLETON == destVal) {
                log.debug("field '{}' {} value '{}' is not mutable, so no values will be mutated", new Object[]{srcField.getName(), srcVal.getClass().getSimpleName(), srcVal});
                return srcField;
            }
            if (DELETE_VALUE_SINGLETON == destVal) {
                if (!log.isDebugEnabled()) continue;
                if (null == messages) {
                    messages = new ArrayList<String>();
                }
                messages.add(String.format(Locale.ROOT, "removing value from field '%s': %s '%s'", srcField.getName(), srcVal.getClass().getSimpleName(), srcVal));
                continue;
            }
            if (log.isDebugEnabled()) {
                if (null == messages) {
                    messages = new ArrayList();
                }
                messages.add(String.format(Locale.ROOT, "replace value from field '%s': %s '%s' with %s '%s'", srcField.getName(), srcVal.getClass().getSimpleName(), srcVal, destVal.getClass().getSimpleName(), destVal));
            }
            result.addValue(destVal, 1.0f);
        }
        result.setBoost(srcField.getBoost());
        if (null != messages && log.isDebugEnabled()) {
            for (String message : messages) {
                log.debug(message);
            }
        }
        return 0 == result.getValueCount() ? null : result;
    }
}

