/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.search.Sort;
import org.apache.solr.cloud.ActionThrottle;
import org.apache.solr.cloud.RecoveryStrategy;
import org.apache.solr.common.SolrException;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.CoreDescriptor;
import org.apache.solr.core.DirectoryFactory;
import org.apache.solr.core.SolrCore;
import org.apache.solr.index.SortingMergePolicy;
import org.apache.solr.logging.MDCLoggingContext;
import org.apache.solr.update.SolrCoreState;
import org.apache.solr.update.SolrIndexWriter;
import org.apache.solr.util.RefCounted;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultSolrCoreState
extends SolrCoreState
implements RecoveryStrategy.RecoveryListener {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final boolean SKIP_AUTO_RECOVERY = Boolean.getBoolean("solrcloud.skip.autorecovery");
    private final ReentrantLock recoveryLock = new ReentrantLock();
    private final ActionThrottle recoveryThrottle = new ActionThrottle("recovery", 10000L);
    private final ActionThrottle leaderThrottle = new ActionThrottle("leader", 5000L);
    private final AtomicInteger recoveryWaiting = new AtomicInteger();
    private final ReentrantReadWriteLock iwLock = new ReentrantReadWriteLock();
    private SolrIndexWriter indexWriter = null;
    private DirectoryFactory directoryFactory;
    private final RecoveryStrategy.Builder recoveryStrategyBuilder;
    private volatile RecoveryStrategy recoveryStrat;
    private volatile boolean lastReplicationSuccess = true;
    private volatile boolean recoveringAfterStartup = true;
    private RefCounted<IndexWriter> refCntWriter;
    protected final ReentrantLock commitLock = new ReentrantLock();

    @Deprecated
    public DefaultSolrCoreState(DirectoryFactory directoryFactory) {
        this(directoryFactory, new RecoveryStrategy.Builder());
    }

    public DefaultSolrCoreState(DirectoryFactory directoryFactory, RecoveryStrategy.Builder recoveryStrategyBuilder) {
        this.directoryFactory = directoryFactory;
        this.recoveryStrategyBuilder = recoveryStrategyBuilder;
    }

    private void closeIndexWriter(SolrCoreState.IndexWriterCloser closer) {
        try {
            log.debug("SolrCoreState ref count has reached 0 - closing IndexWriter");
            if (closer != null) {
                log.debug("closing IndexWriter with IndexWriterCloser");
                closer.closeWriter(this.indexWriter);
            } else if (this.indexWriter != null) {
                log.debug("closing IndexWriter...");
                this.indexWriter.close();
            }
            this.indexWriter = null;
        }
        catch (Exception e) {
            log.error("Error during close of writer.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public RefCounted<IndexWriter> getIndexWriter(SolrCore core) throws IOException {
        boolean succeeded;
        block8: {
            block9: {
                succeeded = false;
                this.lock(this.iwLock.readLock());
                try {
                    DefaultSolrCoreState defaultSolrCoreState = this;
                    // MONITORENTER : defaultSolrCoreState
                    if (core == null) {
                        this.initRefCntWriter();
                        if (this.refCntWriter == null) {
                            RefCounted<IndexWriter> refCounted = null;
                            // MONITOREXIT : defaultSolrCoreState
                            if (succeeded) return refCounted;
                            this.iwLock.readLock().unlock();
                            return refCounted;
                        }
                        break block8;
                    }
                    if (this.indexWriter != null) break block9;
                }
                catch (Throwable throwable) {
                    if (succeeded) throw throwable;
                    this.iwLock.readLock().unlock();
                    throw throwable;
                }
                this.indexWriter = this.createMainIndexWriter(core, "DirectUpdateHandler2");
            }
            this.initRefCntWriter();
        }
        this.refCntWriter.incref();
        succeeded = true;
        RefCounted<IndexWriter> refCounted = this.refCntWriter;
        // MONITOREXIT : defaultSolrCoreState
        if (succeeded) return refCounted;
        this.iwLock.readLock().unlock();
        return refCounted;
    }

    private void initRefCntWriter() {
        if (this.refCntWriter == null && this.indexWriter != null) {
            this.refCntWriter = new RefCounted<IndexWriter>((IndexWriter)this.indexWriter){

                @Override
                public void decref() {
                    DefaultSolrCoreState.this.iwLock.readLock().unlock();
                    super.decref();
                }

                @Override
                public void close() {
                }
            };
        }
    }

    private void lock(Lock lock) {
        boolean acquired = false;
        do {
            try {
                acquired = lock.tryLock(100L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                log.warn("WARNING - Dangerous interrupt", (Throwable)e);
            }
            if (!this.closed) continue;
            if (acquired) {
                lock.unlock();
            }
            throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "SolrCoreState already closed.");
        } while (!acquired);
    }

    private void changeWriter(SolrCore core, boolean rollback, boolean openNewWriter) throws IOException {
        String coreName = core.getName();
        this.refCntWriter = null;
        SolrIndexWriter iw = this.indexWriter;
        this.indexWriter = null;
        if (iw != null) {
            if (!rollback) {
                try {
                    log.debug("Closing old IndexWriter... core=" + coreName);
                    iw.close();
                }
                catch (Exception e) {
                    SolrException.log((Logger)log, (String)("Error closing old IndexWriter. core=" + coreName), (Throwable)e);
                }
            } else {
                try {
                    log.debug("Rollback old IndexWriter... core=" + coreName);
                    iw.rollback();
                }
                catch (Exception e) {
                    SolrException.log((Logger)log, (String)("Error rolling back old IndexWriter. core=" + coreName), (Throwable)e);
                }
            }
        }
        if (openNewWriter) {
            this.indexWriter = this.createMainIndexWriter(core, "DirectUpdateHandler2");
            log.info("New IndexWriter is ready to be used.");
        }
    }

    @Override
    public void newIndexWriter(SolrCore core, boolean rollback) throws IOException {
        this.lock(this.iwLock.writeLock());
        try {
            this.changeWriter(core, rollback, true);
        }
        finally {
            this.iwLock.writeLock().unlock();
        }
    }

    @Override
    public void closeIndexWriter(SolrCore core, boolean rollback) throws IOException {
        this.lock(this.iwLock.writeLock());
        this.changeWriter(core, rollback, false);
    }

    @Override
    public void openIndexWriter(SolrCore core) throws IOException {
        try {
            this.changeWriter(core, false, true);
        }
        finally {
            this.iwLock.writeLock().unlock();
        }
    }

    @Override
    public void rollbackIndexWriter(SolrCore core) throws IOException {
        this.changeWriter(core, true, true);
    }

    protected SolrIndexWriter createMainIndexWriter(SolrCore core, String name) throws IOException {
        return SolrIndexWriter.create(core, name, core.getNewIndexDir(), core.getDirectoryFactory(), false, core.getLatestSchema(), core.getSolrConfig().indexConfig, core.getDeletionPolicy(), core.getCodec());
    }

    @Override
    public Sort getMergePolicySort() throws IOException {
        this.lock(this.iwLock.readLock());
        try {
            MergePolicy mergePolicy;
            if (this.indexWriter != null && (mergePolicy = this.indexWriter.getConfig().getMergePolicy()) instanceof SortingMergePolicy) {
                Sort sort = ((SortingMergePolicy)mergePolicy).getSort();
                return sort;
            }
        }
        finally {
            this.iwLock.readLock().unlock();
        }
        return null;
    }

    @Override
    public DirectoryFactory getDirectoryFactory() {
        return this.directoryFactory;
    }

    @Override
    public RecoveryStrategy.Builder getRecoveryStrategyBuilder() {
        return this.recoveryStrategyBuilder;
    }

    @Override
    public void doRecovery(final CoreContainer cc, final CoreDescriptor cd) {
        Thread thread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                MDCLoggingContext.setCoreDescriptor(cc, cd);
                try {
                    if (DefaultSolrCoreState.this.SKIP_AUTO_RECOVERY) {
                        log.warn("Skipping recovery according to sys prop solrcloud.skip.autorecovery");
                        return;
                    }
                    if (cc.isShutDown()) {
                        log.warn("Skipping recovery because Solr is shutdown");
                        return;
                    }
                    boolean locked = DefaultSolrCoreState.this.recoveryLock.tryLock();
                    try {
                        if (!locked) {
                            if (DefaultSolrCoreState.this.recoveryWaiting.get() > 0) {
                                return;
                            }
                            DefaultSolrCoreState.this.recoveryWaiting.incrementAndGet();
                        } else {
                            DefaultSolrCoreState.this.recoveryWaiting.incrementAndGet();
                            DefaultSolrCoreState.this.cancelRecovery();
                        }
                        DefaultSolrCoreState.this.recoveryLock.lock();
                        try {
                            DefaultSolrCoreState.this.recoveryWaiting.decrementAndGet();
                            if (cc.isShutDown()) {
                                log.warn("Skipping recovery because Solr is shutdown");
                                return;
                            }
                            log.info("Running recovery");
                            DefaultSolrCoreState.this.recoveryThrottle.minimumWaitBetweenActions();
                            DefaultSolrCoreState.this.recoveryThrottle.markAttemptingAction();
                            DefaultSolrCoreState.this.recoveryStrat = DefaultSolrCoreState.this.recoveryStrategyBuilder.create(cc, cd, DefaultSolrCoreState.this);
                            DefaultSolrCoreState.this.recoveryStrat.setRecoveringAfterStartup(DefaultSolrCoreState.this.recoveringAfterStartup);
                            Future<?> future = cc.getUpdateShardHandler().getRecoveryExecutor().submit(DefaultSolrCoreState.this.recoveryStrat);
                            try {
                                future.get();
                                return;
                            }
                            catch (InterruptedException e) {
                                Thread.currentThread().interrupt();
                                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
                            }
                            catch (ExecutionException e) {
                                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
                            }
                        }
                        finally {
                            DefaultSolrCoreState.this.recoveryLock.unlock();
                        }
                    }
                    finally {
                        if (locked) {
                            DefaultSolrCoreState.this.recoveryLock.unlock();
                        }
                    }
                }
                finally {
                    MDCLoggingContext.clear();
                }
            }
        };
        try {
            cc.getUpdateShardHandler().getUpdateExecutor().submit(thread);
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    @Override
    public void cancelRecovery() {
        if (this.recoveryStrat != null) {
            try {
                this.recoveryStrat.close();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    @Override
    public void recovered() {
        this.recoveryStrat = null;
        this.recoveringAfterStartup = false;
    }

    @Override
    public void failed() {
        this.recoveryStrat = null;
    }

    @Override
    public synchronized void close(SolrCoreState.IndexWriterCloser closer) {
        this.closed = true;
        this.cancelRecovery();
        this.closeIndexWriter(closer);
    }

    @Override
    public Lock getCommitLock() {
        return this.commitLock;
    }

    @Override
    public ActionThrottle getLeaderThrottle() {
        return this.leaderThrottle;
    }

    @Override
    public boolean getLastReplicateIndexSuccess() {
        return this.lastReplicationSuccess;
    }

    @Override
    public void setLastReplicateIndexSuccess(boolean success) {
        this.lastReplicationSuccess = success;
    }

    @Override
    public Lock getRecoveryLock() {
        return this.recoveryLock;
    }
}

