/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.metrics.reporters;

import com.codahale.metrics.JmxReporter;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ObjectNameFactory;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.management.MBeanServer;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.metrics.SolrMetricManager;
import org.apache.solr.metrics.SolrMetricReporter;
import org.apache.solr.metrics.reporters.JmxObjectNameFactory;
import org.apache.solr.metrics.reporters.ReporterClientCache;
import org.apache.solr.util.JmxUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrJmxReporter
extends SolrMetricReporter {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final ReporterClientCache<MBeanServer> serviceRegistry = new ReporterClientCache();
    private String domain;
    private String agentId;
    private String serviceUrl;
    private String rootName;
    private List<String> filters = new ArrayList<String>();
    private JmxReporter reporter;
    private MetricRegistry registry;
    private MBeanServer mBeanServer;

    public SolrJmxReporter(SolrMetricManager metricManager, String registryName) {
        super(metricManager, registryName);
        this.setDomain(registryName);
    }

    @Override
    public synchronized void init(PluginInfo pluginInfo) {
        super.init(pluginInfo);
        if (!this.enabled) {
            log.info("Reporter disabled for registry " + this.registryName);
            return;
        }
        log.debug("Initializing for registry " + this.registryName);
        if (this.serviceUrl != null && this.agentId != null) {
            this.mBeanServer = JmxUtil.findFirstMBeanServer();
            log.warn("No more than one of serviceUrl({}) and agentId({}) should be configured, using first MBeanServer instead of configuration.", new Object[]{this.serviceUrl, this.agentId, this.mBeanServer});
        } else if (this.serviceUrl != null) {
            this.mBeanServer = serviceRegistry.getOrCreate(this.serviceUrl, () -> JmxUtil.findMBeanServerForServiceUrl(this.serviceUrl));
        } else if (this.agentId != null) {
            this.mBeanServer = JmxUtil.findMBeanServerForAgentId(this.agentId);
        } else {
            this.mBeanServer = JmxUtil.findFirstMBeanServer();
            log.debug("No serviceUrl or agentId was configured, using first MBeanServer: " + this.mBeanServer);
        }
        if (this.mBeanServer == null) {
            log.warn("No JMX server found. Not exposing Solr metrics via JMX.");
            return;
        }
        if (this.domain == null || this.domain.isEmpty()) {
            this.domain = this.registryName;
        }
        String fullDomain = this.domain;
        if (this.rootName != null && !this.rootName.isEmpty()) {
            fullDomain = this.rootName + "." + this.domain;
        }
        JmxObjectNameFactory jmxObjectNameFactory = new JmxObjectNameFactory(pluginInfo.name, fullDomain, new String[0]);
        this.registry = this.metricManager.registry(this.registryName);
        Object filter = this.filters.isEmpty() ? MetricFilter.ALL : new SolrMetricManager.PrefixFilter(this.filters);
        this.reporter = JmxReporter.forRegistry((MetricRegistry)this.registry).registerWith(this.mBeanServer).inDomain(fullDomain).filter(filter).createsObjectNamesWith((ObjectNameFactory)jmxObjectNameFactory).build();
        this.reporter.start();
        log.info("JMX monitoring for '" + fullDomain + "' (registry '" + this.registryName + "') enabled at server: " + this.mBeanServer);
    }

    @Override
    public synchronized void close() {
        if (this.reporter != null) {
            this.reporter.close();
            this.reporter = null;
        }
    }

    @Override
    protected void validate() throws IllegalStateException {
    }

    public void setRootName(String rootName) {
        this.rootName = rootName;
    }

    public void setDomain(String domain) {
        this.domain = domain != null ? domain : this.registryName;
    }

    public void setServiceUrl(String serviceUrl) {
        this.serviceUrl = serviceUrl;
    }

    public void setAgentId(String agentId) {
        this.agentId = agentId;
    }

    public String getAgentId() {
        return this.agentId;
    }

    public String getServiceUrl() {
        return this.serviceUrl;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setFilter(List<String> filters) {
        if (filters == null || filters.isEmpty()) {
            return;
        }
        this.filters.addAll(filters);
    }

    public void setFilter(String filter) {
        if (filter != null && !filter.isEmpty()) {
            this.filters.add(filter);
        }
    }

    public MBeanServer getMBeanServer() {
        return this.mBeanServer;
    }

    public boolean isActive() {
        return this.reporter != null;
    }

    @Override
    public String toString() {
        return String.format(Locale.ENGLISH, "[%s@%s: rootName = %s, domain = %s, service url = %s, agent id = %s]", this.getClass().getName(), Integer.toHexString(this.hashCode()), this.rootName, this.domain, this.serviceUrl, this.agentId);
    }
}

