/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.MultiDocValues;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.BitSetIterator;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CharsRefBuilder;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.LongValues;
import org.apache.solr.common.IteratorWriter;
import org.apache.solr.common.MapWriter;
import org.apache.solr.common.PushWriter;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.JavaBinCodec;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.SolrCore;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrRequestInfo;
import org.apache.solr.response.BinaryResponseWriter;
import org.apache.solr.response.JSONResponseWriter;
import org.apache.solr.response.QueryResponseWriter;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.schema.BoolField;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.schema.StrField;
import org.apache.solr.schema.TrieDateField;
import org.apache.solr.schema.TrieDoubleField;
import org.apache.solr.schema.TrieFloatField;
import org.apache.solr.schema.TrieIntField;
import org.apache.solr.schema.TrieLongField;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.SortSpec;
import org.apache.solr.search.SyntaxError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportWriter
implements SolrCore.RawWriter,
Closeable {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private OutputStreamWriter respWriter;
    final SolrQueryRequest req;
    final SolrQueryResponse res;
    FieldWriter[] fieldWriters;
    int totalHits = 0;
    FixedBitSet[] sets = null;
    PushWriter writer;
    private String wt;

    ExportWriter(SolrQueryRequest req, SolrQueryResponse res, String wt) {
        this.req = req;
        this.res = res;
        this.wt = wt;
    }

    @Override
    public String getContentType() {
        if ("javabin".equals(this.wt)) {
            return "application/octet-stream";
        }
        return "json";
    }

    @Override
    public void close() throws IOException {
        if (this.writer != null) {
            this.writer.close();
        }
        if (this.respWriter != null) {
            this.respWriter.flush();
            this.respWriter.close();
        }
    }

    protected void writeException(Exception e, PushWriter w, boolean log) throws IOException {
        w.writeMap(mw -> mw.put("responseHeader", Collections.singletonMap("status", 400)).put("response", (Object)Utils.makeMap((Object[])new Object[]{"numFound", 0, "docs", Collections.singletonList(Collections.singletonMap("EXCEPTION", e.getMessage()))})));
        if (log) {
            SolrException.log((Logger)logger, (Throwable)e);
        }
    }

    @Override
    public void write(OutputStream os) throws IOException {
        QueryResponseWriter rw = this.req.getCore().getResponseWriters().get(this.wt);
        if (rw instanceof BinaryResponseWriter) {
            this.writer = new JavaBinCodec(os, null);
        } else {
            this.respWriter = new OutputStreamWriter(os, StandardCharsets.UTF_8);
            this.writer = JSONResponseWriter.getPushWriter(this.respWriter, this.req, this.res);
        }
        Exception exception = this.res.getException();
        if (exception != null) {
            if (!(exception instanceof IgnoreException)) {
                this.writeException(exception, this.writer, false);
            }
            return;
        }
        SolrRequestInfo info = SolrRequestInfo.getRequestInfo();
        SortSpec sortSpec = info.getResponseBuilder().getSortSpec();
        if (sortSpec == null) {
            this.writeException(new IOException(new SyntaxError("No sort criteria was provided.")), this.writer, true);
            return;
        }
        SolrIndexSearcher searcher = this.req.getSearcher();
        Sort sort = searcher.weightSort(sortSpec.getSort());
        if (sort == null) {
            this.writeException(new IOException(new SyntaxError("No sort criteria was provided.")), this.writer, true);
            return;
        }
        if (sort != null && sort.needsScores()) {
            this.writeException(new IOException(new SyntaxError("Scoring is not currently supported with xsort.")), this.writer, true);
            return;
        }
        if (this.req.getContext().get("totalHits") != null) {
            this.totalHits = (Integer)this.req.getContext().get("totalHits");
            this.sets = (FixedBitSet[])this.req.getContext().get("export");
            if (this.sets == null) {
                this.writeException(new IOException(new SyntaxError("xport RankQuery is required for xsort: rq={!xport}")), this.writer, true);
                return;
            }
        }
        SolrParams params = this.req.getParams();
        String fl = params.get("fl");
        String[] fields = null;
        if (fl == null) {
            this.writeException(new IOException(new SyntaxError("export field list (fl) must be specified.")), this.writer, true);
            return;
        }
        fields = fl.split(",");
        for (int i = 0; i < fields.length; ++i) {
            fields[i] = fields[i].trim();
            if (!fields[i].equals("score")) continue;
            this.writeException(new IOException(new SyntaxError("Scoring is not currently supported with xsort.")), this.writer, true);
            return;
        }
        try {
            this.fieldWriters = this.getFieldWriters(fields, this.req.getSearcher());
        }
        catch (Exception e) {
            this.writeException(e, this.writer, true);
            return;
        }
        this.writer.writeMap(m -> {
            m.put("responseHeader", Collections.singletonMap("status", 0));
            m.put("response", mw -> {
                mw.put("numFound", this.totalHits);
                mw.put("docs", iw -> this.writeDocs(this.req, iw, sort));
            });
        });
    }

    protected void writeDocs(SolrQueryRequest req, IteratorWriter.ItemWriter writer, Sort sort) throws IOException {
        List leaves = req.getSearcher().getTopReaderContext().leaves();
        SortDoc sortDoc = this.getSortDoc(req.getSearcher(), sort.getSort());
        int count = 0;
        int queueSize = 30000;
        SortQueue queue = new SortQueue(queueSize, sortDoc);
        SortDoc[] outDocs = new SortDoc[queueSize];
        while (count < this.totalHits) {
            int i;
            queue.reset();
            SortDoc top = (SortDoc)queue.top();
            for (int i2 = 0; i2 < leaves.size(); ++i2) {
                sortDoc.setNextReader((LeafReaderContext)leaves.get(i2));
                BitSetIterator it = new BitSetIterator((BitSet)this.sets[i2], 0L);
                int docId = -1;
                while ((docId = it.nextDoc()) != Integer.MAX_VALUE) {
                    sortDoc.setValues(docId);
                    if (!top.lessThan(sortDoc)) continue;
                    top.setValues(sortDoc);
                    top = (SortDoc)queue.updateTop();
                }
            }
            int outDocsIndex = -1;
            for (i = 0; i < queueSize; ++i) {
                SortDoc s = (SortDoc)queue.pop();
                if (s.docId <= -1) continue;
                outDocs[++outDocsIndex] = s;
            }
            count += outDocsIndex + 1;
            try {
                for (i = outDocsIndex; i >= 0; --i) {
                    SortDoc s = outDocs[i];
                    writer.add(ew -> {
                        this.writeDoc(s, leaves, ew);
                        s.reset();
                    });
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                for (Throwable ex = e; ex != null; ex = ex.getCause()) {
                    String m = ex.getMessage();
                    if (m == null || !m.contains("Broken pipe")) continue;
                    throw new IgnoreException();
                }
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                throw new IOException(e);
            }
        }
    }

    protected void writeDoc(SortDoc sortDoc, List<LeafReaderContext> leaves, MapWriter.EntryWriter ew) throws IOException {
        int ord = sortDoc.ord;
        FixedBitSet set = this.sets[ord];
        set.clear(sortDoc.docId);
        LeafReaderContext context = leaves.get(ord);
        int fieldIndex = 0;
        for (FieldWriter fieldWriter : this.fieldWriters) {
            if (!fieldWriter.write(sortDoc.docId, context.reader(), ew, fieldIndex)) continue;
            ++fieldIndex;
        }
    }

    protected FieldWriter[] getFieldWriters(String[] fields, SolrIndexSearcher searcher) throws IOException {
        IndexSchema schema = searcher.getSchema();
        FieldWriter[] writers = new FieldWriter[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            String field = fields[i];
            SchemaField schemaField = null;
            try {
                schemaField = schema.getField(field);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            if (!schemaField.hasDocValues()) {
                throw new IOException(field + " must have DocValues to use this feature.");
            }
            boolean multiValued = schemaField.multiValued();
            FieldType fieldType = schemaField.getType();
            if (fieldType instanceof TrieIntField) {
                if (multiValued) {
                    writers[i] = new MultiFieldWriter(field, fieldType, schemaField, true);
                    continue;
                }
                writers[i] = new IntFieldWriter(field);
                continue;
            }
            if (fieldType instanceof TrieLongField) {
                if (multiValued) {
                    writers[i] = new MultiFieldWriter(field, fieldType, schemaField, true);
                    continue;
                }
                writers[i] = new LongFieldWriter(field);
                continue;
            }
            if (fieldType instanceof TrieFloatField) {
                if (multiValued) {
                    writers[i] = new MultiFieldWriter(field, fieldType, schemaField, true);
                    continue;
                }
                writers[i] = new FloatFieldWriter(field);
                continue;
            }
            if (fieldType instanceof TrieDoubleField) {
                if (multiValued) {
                    writers[i] = new MultiFieldWriter(field, fieldType, schemaField, true);
                    continue;
                }
                writers[i] = new DoubleFieldWriter(field);
                continue;
            }
            if (fieldType instanceof StrField) {
                if (multiValued) {
                    writers[i] = new MultiFieldWriter(field, fieldType, schemaField, false);
                    continue;
                }
                writers[i] = new StringFieldWriter(field, fieldType);
                continue;
            }
            if (fieldType instanceof TrieDateField) {
                if (multiValued) {
                    writers[i] = new MultiFieldWriter(field, fieldType, schemaField, false);
                    continue;
                }
                writers[i] = new DateFieldWriter(field);
                continue;
            }
            if (fieldType instanceof BoolField) {
                if (multiValued) {
                    writers[i] = new MultiFieldWriter(field, fieldType, schemaField, true);
                    continue;
                }
                writers[i] = new BoolFieldWriter(field, fieldType);
                continue;
            }
            throw new IOException("Export fields must either be one of the following types: int,float,long,double,string,date,boolean");
        }
        return writers;
    }

    private SortDoc getSortDoc(SolrIndexSearcher searcher, SortField[] sortFields) throws IOException {
        SortValue[] sortValues = new SortValue[sortFields.length];
        IndexSchema schema = searcher.getSchema();
        for (int i = 0; i < sortFields.length; ++i) {
            SortedDocValues vals;
            LeafReader reader;
            SortField sf = sortFields[i];
            String field = sf.getField();
            boolean reverse = sf.getReverse();
            SchemaField schemaField = schema.getField(field);
            FieldType ft = schemaField.getType();
            if (!schemaField.hasDocValues()) {
                throw new IOException(field + " must have DocValues to use this feature.");
            }
            if (ft instanceof TrieIntField) {
                if (reverse) {
                    sortValues[i] = new IntValue(field, new IntDesc());
                    continue;
                }
                sortValues[i] = new IntValue(field, new IntAsc());
                continue;
            }
            if (ft instanceof TrieFloatField) {
                if (reverse) {
                    sortValues[i] = new FloatValue(field, new FloatDesc());
                    continue;
                }
                sortValues[i] = new FloatValue(field, new FloatAsc());
                continue;
            }
            if (ft instanceof TrieDoubleField) {
                if (reverse) {
                    sortValues[i] = new DoubleValue(field, new DoubleDesc());
                    continue;
                }
                sortValues[i] = new DoubleValue(field, new DoubleAsc());
                continue;
            }
            if (ft instanceof TrieLongField) {
                if (reverse) {
                    sortValues[i] = new LongValue(field, new LongDesc());
                    continue;
                }
                sortValues[i] = new LongValue(field, new LongAsc());
                continue;
            }
            if (ft instanceof StrField) {
                reader = searcher.getSlowAtomicReader();
                vals = reader.getSortedDocValues(field);
                if (reverse) {
                    sortValues[i] = new StringValue(vals, field, new IntDesc());
                    continue;
                }
                sortValues[i] = new StringValue(vals, field, new IntAsc());
                continue;
            }
            if (ft instanceof TrieDateField) {
                if (reverse) {
                    sortValues[i] = new LongValue(field, new LongDesc());
                    continue;
                }
                sortValues[i] = new LongValue(field, new LongAsc());
                continue;
            }
            if (ft instanceof BoolField) {
                reader = searcher.getSlowAtomicReader();
                vals = reader.getSortedDocValues(field);
                if (reverse) {
                    sortValues[i] = new StringValue(vals, field, new IntDesc());
                    continue;
                }
                sortValues[i] = new StringValue(vals, field, new IntAsc());
                continue;
            }
            throw new IOException("Sort fields must be one of the following types: int,float,long,double,string,date,boolean");
        }
        if (sortValues.length == 1) {
            return new SingleValueSortDoc(sortValues[0]);
        }
        if (sortValues.length == 2) {
            return new DoubleValueSortDoc(sortValues[0], sortValues[1]);
        }
        if (sortValues.length == 3) {
            return new TripleValueSortDoc(sortValues[0], sortValues[1], sortValues[2]);
        }
        if (sortValues.length == 4) {
            return new QuadValueSortDoc(sortValues[0], sortValues[1], sortValues[2], sortValues[3]);
        }
        throw new IOException("A max of 4 sorts can be specified");
    }

    public static class IgnoreException
    extends IOException {
        @Override
        public void printStackTrace(PrintWriter pw) {
            pw.print("Early Client Disconnect");
        }

        @Override
        public String getMessage() {
            return "Early Client Disconnect";
        }
    }

    public abstract class PriorityQueue<T> {
        protected int size = 0;
        protected final int maxSize;
        private final T[] heap;

        public PriorityQueue(int maxSize) {
            this(maxSize, true);
        }

        public PriorityQueue(int maxSize, boolean prepopulate) {
            T sentinel;
            int heapSize;
            if (0 == maxSize) {
                heapSize = 2;
            } else {
                if (maxSize > ArrayUtil.MAX_ARRAY_LENGTH) {
                    throw new IllegalArgumentException("maxSize must be <= " + ArrayUtil.MAX_ARRAY_LENGTH + "; got: " + maxSize);
                }
                heapSize = maxSize + 1;
            }
            Object[] h = new Object[heapSize];
            this.heap = h;
            this.maxSize = maxSize;
            if (prepopulate && (sentinel = this.getSentinelObject()) != null) {
                this.heap[1] = sentinel;
                for (int i = 2; i < this.heap.length; ++i) {
                    this.heap[i] = this.getSentinelObject();
                }
                this.size = maxSize;
            }
        }

        protected abstract boolean lessThan(T var1, T var2);

        protected T getSentinelObject() {
            return null;
        }

        public final T add(T element) {
            ++this.size;
            this.heap[this.size] = element;
            this.upHeap();
            return this.heap[1];
        }

        public T insertWithOverflow(T element) {
            if (this.size < this.maxSize) {
                this.add(element);
                return null;
            }
            if (this.size > 0 && !this.lessThan(element, this.heap[1])) {
                T ret = this.heap[1];
                this.heap[1] = element;
                this.updateTop();
                return ret;
            }
            return element;
        }

        public final T top() {
            return this.heap[1];
        }

        public final T pop() {
            if (this.size > 0) {
                T result = this.heap[1];
                this.heap[1] = this.heap[this.size];
                this.heap[this.size] = null;
                --this.size;
                this.downHeap();
                return result;
            }
            return null;
        }

        public final T updateTop() {
            this.downHeap();
            return this.heap[1];
        }

        public final int size() {
            return this.size;
        }

        public final void clear() {
            for (int i = 0; i <= this.size; ++i) {
                this.heap[i] = null;
            }
            this.size = 0;
        }

        private final void upHeap() {
            int i = this.size;
            T node = this.heap[i];
            for (int j = i >>> 1; j > 0 && this.lessThan(node, this.heap[j]); j >>>= 1) {
                this.heap[i] = this.heap[j];
                i = j;
            }
            this.heap[i] = node;
        }

        private final void downHeap() {
            int i = 1;
            T node = this.heap[i];
            int j = i << 1;
            int k = j + 1;
            if (k <= this.size && this.lessThan(this.heap[k], this.heap[j])) {
                j = k;
            }
            while (j <= this.size && this.lessThan(this.heap[j], node)) {
                this.heap[i] = this.heap[j];
                i = j;
                k = (j = i << 1) + 1;
                if (k > this.size || !this.lessThan(this.heap[k], this.heap[j])) continue;
                j = k;
            }
            this.heap[i] = node;
        }

        public final Object[] getHeapArray() {
            return this.heap;
        }
    }

    class StringFieldWriter
    extends FieldWriter {
        private String field;
        private FieldType fieldType;
        private CharsRefBuilder cref;

        public StringFieldWriter(String field, FieldType fieldType) {
            this.cref = new CharsRefBuilder();
            this.field = field;
            this.fieldType = fieldType;
        }

        @Override
        public boolean write(int docId, LeafReader reader, MapWriter.EntryWriter ew, int fieldIndex) throws IOException {
            SortedDocValues vals = DocValues.getSorted((LeafReader)reader, (String)this.field);
            int ord = vals.getOrd(docId);
            if (ord == -1) {
                return false;
            }
            BytesRef ref = vals.lookupOrd(ord);
            this.fieldType.indexedToReadable(ref, this.cref);
            ew.put(this.field, (Object)this.cref.toString());
            return true;
        }
    }

    class DoubleFieldWriter
    extends FieldWriter {
        private String field;

        public DoubleFieldWriter(String field) {
            this.field = field;
        }

        @Override
        public boolean write(int docId, LeafReader reader, MapWriter.EntryWriter ew, int fieldIndex) throws IOException {
            NumericDocValues vals = DocValues.getNumeric((LeafReader)reader, (String)this.field);
            long val = vals.get(docId);
            if (!this.checkExists(docId, val, this.field, reader)) {
                return false;
            }
            ew.put(this.field, Double.longBitsToDouble(val));
            return true;
        }
    }

    class FloatFieldWriter
    extends FieldWriter {
        private String field;

        public FloatFieldWriter(String field) {
            this.field = field;
        }

        @Override
        public boolean write(int docId, LeafReader reader, MapWriter.EntryWriter ew, int fieldIndex) throws IOException {
            NumericDocValues vals = DocValues.getNumeric((LeafReader)reader, (String)this.field);
            int val = (int)vals.get(docId);
            if (!this.checkExists(docId, val, this.field, reader)) {
                return false;
            }
            ew.put(this.field, Float.intBitsToFloat(val));
            return true;
        }
    }

    class BoolFieldWriter
    extends FieldWriter {
        private String field;
        private FieldType fieldType;
        private CharsRefBuilder cref;

        public BoolFieldWriter(String field, FieldType fieldType) {
            this.cref = new CharsRefBuilder();
            this.field = field;
            this.fieldType = fieldType;
        }

        @Override
        public boolean write(int docId, LeafReader reader, MapWriter.EntryWriter ew, int fieldIndex) throws IOException {
            SortedDocValues vals = DocValues.getSorted((LeafReader)reader, (String)this.field);
            int ord = vals.getOrd(docId);
            if (ord == -1) {
                return false;
            }
            BytesRef ref = vals.lookupOrd(ord);
            this.fieldType.indexedToReadable(ref, this.cref);
            ew.put(this.field, "true".equals(this.cref.toString()));
            return true;
        }
    }

    class DateFieldWriter
    extends FieldWriter {
        private String field;

        public DateFieldWriter(String field) {
            this.field = field;
        }

        @Override
        public boolean write(int docId, LeafReader reader, MapWriter.EntryWriter ew, int fieldIndex) throws IOException {
            NumericDocValues vals = DocValues.getNumeric((LeafReader)reader, (String)this.field);
            long val = vals.get(docId);
            if (!this.checkExists(docId, val, this.field, reader)) {
                return false;
            }
            ew.put(this.field, (Object)new Date(val));
            return true;
        }
    }

    class LongFieldWriter
    extends FieldWriter {
        private String field;

        public LongFieldWriter(String field) {
            this.field = field;
        }

        @Override
        public boolean write(int docId, LeafReader reader, MapWriter.EntryWriter ew, int fieldIndex) throws IOException {
            NumericDocValues vals = DocValues.getNumeric((LeafReader)reader, (String)this.field);
            long val = vals.get(docId);
            if (!this.checkExists(docId, val, this.field, reader)) {
                return false;
            }
            ew.put(this.field, val);
            return true;
        }
    }

    class MultiFieldWriter
    extends FieldWriter {
        private String field;
        private FieldType fieldType;
        private SchemaField schemaField;
        private boolean numeric;
        private CharsRefBuilder cref;

        public MultiFieldWriter(String field, FieldType fieldType, SchemaField schemaField, boolean numeric) {
            this.cref = new CharsRefBuilder();
            this.field = field;
            this.fieldType = fieldType;
            this.schemaField = schemaField;
            this.numeric = numeric;
        }

        @Override
        public boolean write(int docId, LeafReader reader, MapWriter.EntryWriter out, int fieldIndex) throws IOException {
            SortedSetDocValues vals = DocValues.getSortedSet((LeafReader)reader, (String)this.field);
            vals.setDocument(docId);
            long first = vals.nextOrd();
            if (first == -1L) {
                return false;
            }
            out.put(this.field, w -> {
                boolean isFirst = true;
                while (true) {
                    long o;
                    if (isFirst) {
                        isFirst = false;
                        o = first;
                    } else {
                        o = vals.nextOrd();
                    }
                    if (o == -1L) break;
                    BytesRef ref = vals.lookupOrd(o);
                    this.fieldType.indexedToReadable(ref, this.cref);
                    IndexableField f = this.fieldType.createField(this.schemaField, this.cref.toString(), 1.0f);
                    if (f == null) {
                        w.add((Object)this.cref.toString());
                        continue;
                    }
                    w.add(this.fieldType.toObject(f));
                }
            });
            return true;
        }
    }

    class IntFieldWriter
    extends FieldWriter {
        private String field;

        public IntFieldWriter(String field) {
            this.field = field;
        }

        @Override
        public boolean write(int docId, LeafReader reader, MapWriter.EntryWriter ew, int fieldIndex) throws IOException {
            NumericDocValues vals = DocValues.getNumeric((LeafReader)reader, (String)this.field);
            int val = (int)vals.get(docId);
            if (!this.checkExists(docId, val, this.field, reader)) {
                return false;
            }
            ew.put(this.field, val);
            return true;
        }
    }

    protected abstract class FieldWriter {
        protected FieldWriter() {
        }

        public abstract boolean write(int var1, LeafReader var2, MapWriter.EntryWriter var3, int var4) throws IOException;

        protected boolean checkExists(int docId, long val, String field, LeafReader reader) throws IOException {
            if (val != 0L) {
                return true;
            }
            Bits bits = reader.getDocsWithField(field);
            if (bits == null) {
                return false;
            }
            return bits.get(docId);
        }
    }

    class StringValue
    implements SortValue {
        protected SortedDocValues vals;
        protected SortedDocValues[] segmentVals;
        protected MultiDocValues.OrdinalMap ordinalMap;
        protected LongValues globalOrds;
        protected SortedDocValues currentVals;
        protected String field;
        protected int segment;
        protected int currentOrd;
        protected IntComp comp;

        public StringValue(SortedDocValues vals, String field, IntComp comp) {
            this.vals = vals;
            if (vals instanceof MultiDocValues.MultiSortedDocValues) {
                this.segmentVals = ((MultiDocValues.MultiSortedDocValues)vals).values;
                this.ordinalMap = ((MultiDocValues.MultiSortedDocValues)vals).mapping;
            }
            this.field = field;
            this.comp = comp;
            this.currentOrd = comp.resetValue();
        }

        @Override
        public StringValue copy() {
            return new StringValue(this.vals, this.field, this.comp);
        }

        @Override
        public void setCurrentValue(int docId) {
            int ord = this.currentVals.getOrd(docId);
            this.currentOrd = ord < 0 ? -1 : (this.globalOrds != null ? (int)this.globalOrds.get(ord) : ord);
        }

        @Override
        public void setCurrentValue(SortValue sv) {
            StringValue v = (StringValue)sv;
            this.currentOrd = v.currentOrd;
        }

        @Override
        public void setNextReader(LeafReaderContext context) {
            this.segment = context.ord;
            if (this.ordinalMap != null) {
                this.globalOrds = this.ordinalMap.getGlobalOrds(this.segment);
                this.currentVals = this.segmentVals[this.segment];
            } else {
                this.currentVals = this.vals;
            }
        }

        @Override
        public void reset() {
            this.currentOrd = this.comp.resetValue();
        }

        @Override
        public int compareTo(SortValue o) {
            StringValue sv = (StringValue)o;
            return this.comp.compare(this.currentOrd, sv.currentOrd);
        }

        public String toString() {
            return Integer.toString(this.currentOrd);
        }
    }

    public static class DoubleAsc
    implements DoubleComp {
        @Override
        public double resetValue() {
            return Double.MAX_VALUE;
        }

        @Override
        public int compare(double a, double b) {
            if (a < b) {
                return 1;
            }
            if (a > b) {
                return -1;
            }
            return 0;
        }
    }

    public static class DoubleDesc
    implements DoubleComp {
        @Override
        public double resetValue() {
            return -1.7976931348623157E308;
        }

        @Override
        public int compare(double a, double b) {
            if (a < b) {
                return -1;
            }
            if (a > b) {
                return 1;
            }
            return 0;
        }
    }

    static interface DoubleComp {
        public int compare(double var1, double var3);

        public double resetValue();
    }

    class DoubleValue
    implements SortValue {
        protected NumericDocValues vals;
        protected String field;
        protected double currentValue;
        protected DoubleComp comp;

        public DoubleValue(String field, DoubleComp comp) {
            this.field = field;
            this.comp = comp;
            this.currentValue = comp.resetValue();
        }

        @Override
        public DoubleValue copy() {
            return new DoubleValue(this.field, this.comp);
        }

        @Override
        public void setNextReader(LeafReaderContext context) throws IOException {
            this.vals = DocValues.getNumeric((LeafReader)context.reader(), (String)this.field);
        }

        @Override
        public void setCurrentValue(int docId) {
            this.currentValue = Double.longBitsToDouble(this.vals.get(docId));
        }

        @Override
        public void setCurrentValue(SortValue sv) {
            DoubleValue dv = (DoubleValue)sv;
            this.currentValue = dv.currentValue;
        }

        @Override
        public void reset() {
            this.currentValue = this.comp.resetValue();
        }

        @Override
        public int compareTo(SortValue o) {
            DoubleValue dv = (DoubleValue)o;
            return this.comp.compare(this.currentValue, dv.currentValue);
        }
    }

    public static class FloatAsc
    implements FloatComp {
        @Override
        public float resetValue() {
            return Float.MAX_VALUE;
        }

        @Override
        public int compare(float a, float b) {
            if (a < b) {
                return 1;
            }
            if (a > b) {
                return -1;
            }
            return 0;
        }
    }

    public static class FloatDesc
    implements FloatComp {
        @Override
        public float resetValue() {
            return -3.4028235E38f;
        }

        @Override
        public int compare(float a, float b) {
            if (a < b) {
                return -1;
            }
            if (a > b) {
                return 1;
            }
            return 0;
        }
    }

    static interface FloatComp {
        public int compare(float var1, float var2);

        public float resetValue();
    }

    class FloatValue
    implements SortValue {
        protected NumericDocValues vals;
        protected String field;
        protected float currentValue;
        protected FloatComp comp;

        public FloatValue(String field, FloatComp comp) {
            this.field = field;
            this.comp = comp;
            this.currentValue = comp.resetValue();
        }

        @Override
        public FloatValue copy() {
            return new FloatValue(this.field, this.comp);
        }

        @Override
        public void setNextReader(LeafReaderContext context) throws IOException {
            this.vals = DocValues.getNumeric((LeafReader)context.reader(), (String)this.field);
        }

        @Override
        public void setCurrentValue(int docId) {
            this.currentValue = Float.intBitsToFloat((int)this.vals.get(docId));
        }

        @Override
        public void setCurrentValue(SortValue sv) {
            FloatValue fv = (FloatValue)sv;
            this.currentValue = fv.currentValue;
        }

        @Override
        public void reset() {
            this.currentValue = this.comp.resetValue();
        }

        @Override
        public int compareTo(SortValue o) {
            FloatValue fv = (FloatValue)o;
            return this.comp.compare(this.currentValue, fv.currentValue);
        }
    }

    static class LongAsc
    implements LongComp {
        LongAsc() {
        }

        @Override
        public long resetValue() {
            return Long.MAX_VALUE;
        }

        @Override
        public int compare(long a, long b) {
            if (a < b) {
                return 1;
            }
            if (a > b) {
                return -1;
            }
            return 0;
        }
    }

    static class LongDesc
    implements LongComp {
        LongDesc() {
        }

        @Override
        public long resetValue() {
            return Long.MIN_VALUE;
        }

        @Override
        public int compare(long a, long b) {
            if (a < b) {
                return -1;
            }
            if (a > b) {
                return 1;
            }
            return 0;
        }
    }

    static interface LongComp {
        public int compare(long var1, long var3);

        public long resetValue();
    }

    class LongValue
    implements SortValue {
        protected NumericDocValues vals;
        protected String field;
        protected long currentValue;
        protected LongComp comp;

        public LongValue(String field, LongComp comp) {
            this.field = field;
            this.comp = comp;
            this.currentValue = comp.resetValue();
        }

        @Override
        public LongValue copy() {
            return new LongValue(this.field, this.comp);
        }

        @Override
        public void setNextReader(LeafReaderContext context) throws IOException {
            this.vals = DocValues.getNumeric((LeafReader)context.reader(), (String)this.field);
        }

        @Override
        public void setCurrentValue(int docId) {
            this.currentValue = this.vals.get(docId);
        }

        @Override
        public void setCurrentValue(SortValue sv) {
            LongValue lv = (LongValue)sv;
            this.currentValue = lv.currentValue;
        }

        @Override
        public int compareTo(SortValue o) {
            LongValue l = (LongValue)o;
            return this.comp.compare(this.currentValue, l.currentValue);
        }

        @Override
        public void reset() {
            this.currentValue = this.comp.resetValue();
        }
    }

    static class IntAsc
    implements IntComp {
        IntAsc() {
        }

        @Override
        public int resetValue() {
            return Integer.MAX_VALUE;
        }

        @Override
        public int compare(int a, int b) {
            if (a < b) {
                return 1;
            }
            if (a > b) {
                return -1;
            }
            return 0;
        }
    }

    static class IntDesc
    implements IntComp {
        IntDesc() {
        }

        @Override
        public int resetValue() {
            return Integer.MIN_VALUE;
        }

        @Override
        public int compare(int a, int b) {
            if (a < b) {
                return -1;
            }
            if (a > b) {
                return 1;
            }
            return 0;
        }
    }

    public static interface IntComp {
        public int compare(int var1, int var2);

        public int resetValue();
    }

    class IntValue
    implements SortValue {
        protected NumericDocValues vals;
        protected String field;
        protected int currentValue;
        protected IntComp comp;

        @Override
        public IntValue copy() {
            return new IntValue(this.field, this.comp);
        }

        public IntValue(String field, IntComp comp) {
            this.field = field;
            this.comp = comp;
            this.currentValue = comp.resetValue();
        }

        @Override
        public void setNextReader(LeafReaderContext context) throws IOException {
            this.vals = DocValues.getNumeric((LeafReader)context.reader(), (String)this.field);
        }

        @Override
        public void setCurrentValue(int docId) {
            this.currentValue = (int)this.vals.get(docId);
        }

        @Override
        public int compareTo(SortValue o) {
            IntValue iv = (IntValue)o;
            return this.comp.compare(this.currentValue, iv.currentValue);
        }

        @Override
        public void setCurrentValue(SortValue value) {
            this.currentValue = ((IntValue)value).currentValue;
        }

        @Override
        public void reset() {
            this.currentValue = this.comp.resetValue();
        }
    }

    public static interface SortValue
    extends Comparable<SortValue> {
        public void setCurrentValue(int var1) throws IOException;

        public void setNextReader(LeafReaderContext var1) throws IOException;

        public void setCurrentValue(SortValue var1);

        public void reset();

        public SortValue copy();
    }

    class QuadValueSortDoc
    extends TripleValueSortDoc {
        protected SortValue value4;

        @Override
        public void setNextReader(LeafReaderContext context) throws IOException {
            this.ord = context.ord;
            this.value1.setNextReader(context);
            this.value2.setNextReader(context);
            this.value3.setNextReader(context);
            this.value4.setNextReader(context);
        }

        @Override
        public void reset() {
            this.docId = -1;
            this.value1.reset();
            this.value2.reset();
            this.value3.reset();
            this.value4.reset();
        }

        @Override
        public void setValues(int docId) throws IOException {
            this.docId = docId;
            this.value1.setCurrentValue(docId);
            this.value2.setCurrentValue(docId);
            this.value3.setCurrentValue(docId);
            this.value4.setCurrentValue(docId);
        }

        @Override
        public void setValues(SortDoc sortDoc) throws IOException {
            this.docId = sortDoc.docId;
            this.ord = sortDoc.ord;
            this.value1.setCurrentValue(((QuadValueSortDoc)sortDoc).value1);
            this.value2.setCurrentValue(((QuadValueSortDoc)sortDoc).value2);
            this.value3.setCurrentValue(((QuadValueSortDoc)sortDoc).value3);
            this.value4.setCurrentValue(((QuadValueSortDoc)sortDoc).value4);
        }

        public QuadValueSortDoc(SortValue value1, SortValue value2, SortValue value3, SortValue value4) {
            super(value1, value2, value3);
            this.value4 = value4;
        }

        @Override
        public SortDoc copy() {
            return new QuadValueSortDoc(this.value1.copy(), this.value2.copy(), this.value3.copy(), this.value4.copy());
        }

        @Override
        public boolean lessThan(Object o) {
            QuadValueSortDoc sd = (QuadValueSortDoc)o;
            int comp = this.value1.compareTo(sd.value1);
            if (comp == -1) {
                return true;
            }
            if (comp == 1) {
                return false;
            }
            comp = this.value2.compareTo(sd.value2);
            if (comp == -1) {
                return true;
            }
            if (comp == 1) {
                return false;
            }
            comp = this.value3.compareTo(sd.value3);
            if (comp == -1) {
                return true;
            }
            if (comp == 1) {
                return false;
            }
            comp = this.value4.compareTo(sd.value4);
            if (comp == -1) {
                return true;
            }
            if (comp == 1) {
                return false;
            }
            return this.docId + this.docBase > sd.docId + sd.docBase;
        }

        @Override
        public int compareTo(Object o) {
            QuadValueSortDoc sd = (QuadValueSortDoc)o;
            int comp = this.value1.compareTo(sd.value1);
            if (comp == 0) {
                comp = this.value2.compareTo(sd.value2);
                if (comp == 0) {
                    comp = this.value3.compareTo(sd.value3);
                    if (comp == 0) {
                        return this.value4.compareTo(sd.value4);
                    }
                    return comp;
                }
                return comp;
            }
            return comp;
        }
    }

    class TripleValueSortDoc
    extends DoubleValueSortDoc {
        protected SortValue value3;

        @Override
        public void setNextReader(LeafReaderContext context) throws IOException {
            this.ord = context.ord;
            this.value1.setNextReader(context);
            this.value2.setNextReader(context);
            this.value3.setNextReader(context);
        }

        @Override
        public void reset() {
            this.docId = -1;
            this.value1.reset();
            this.value2.reset();
            this.value3.reset();
        }

        @Override
        public void setValues(int docId) throws IOException {
            this.docId = docId;
            this.value1.setCurrentValue(docId);
            this.value2.setCurrentValue(docId);
            this.value3.setCurrentValue(docId);
        }

        @Override
        public void setValues(SortDoc sortDoc) throws IOException {
            this.docId = sortDoc.docId;
            this.ord = sortDoc.ord;
            this.value1.setCurrentValue(((TripleValueSortDoc)sortDoc).value1);
            this.value2.setCurrentValue(((TripleValueSortDoc)sortDoc).value2);
            this.value3.setCurrentValue(((TripleValueSortDoc)sortDoc).value3);
        }

        public TripleValueSortDoc(SortValue value1, SortValue value2, SortValue value3) {
            super(value1, value2);
            this.value3 = value3;
        }

        @Override
        public SortDoc copy() {
            return new TripleValueSortDoc(this.value1.copy(), this.value2.copy(), this.value3.copy());
        }

        @Override
        public boolean lessThan(Object o) {
            TripleValueSortDoc sd = (TripleValueSortDoc)o;
            int comp = this.value1.compareTo(sd.value1);
            if (comp == -1) {
                return true;
            }
            if (comp == 1) {
                return false;
            }
            comp = this.value2.compareTo(sd.value2);
            if (comp == -1) {
                return true;
            }
            if (comp == 1) {
                return false;
            }
            comp = this.value3.compareTo(sd.value3);
            if (comp == -1) {
                return true;
            }
            if (comp == 1) {
                return false;
            }
            return this.docId + this.docBase > sd.docId + sd.docBase;
        }

        @Override
        public int compareTo(Object o) {
            TripleValueSortDoc sd = (TripleValueSortDoc)o;
            int comp = this.value1.compareTo(sd.value1);
            if (comp == 0) {
                comp = this.value2.compareTo(sd.value2);
                if (comp == 0) {
                    return this.value3.compareTo(sd.value3);
                }
                return comp;
            }
            return comp;
        }
    }

    class DoubleValueSortDoc
    extends SingleValueSortDoc {
        protected SortValue value2;

        @Override
        public void setNextReader(LeafReaderContext context) throws IOException {
            this.ord = context.ord;
            this.value1.setNextReader(context);
            this.value2.setNextReader(context);
        }

        @Override
        public void reset() {
            this.docId = -1;
            this.value1.reset();
            this.value2.reset();
        }

        @Override
        public void setValues(int docId) throws IOException {
            this.docId = docId;
            this.value1.setCurrentValue(docId);
            this.value2.setCurrentValue(docId);
        }

        @Override
        public void setValues(SortDoc sortDoc) throws IOException {
            this.docId = sortDoc.docId;
            this.ord = sortDoc.ord;
            this.value1.setCurrentValue(((DoubleValueSortDoc)sortDoc).value1);
            this.value2.setCurrentValue(((DoubleValueSortDoc)sortDoc).value2);
        }

        public DoubleValueSortDoc(SortValue value1, SortValue value2) {
            super(value1);
            this.value2 = value2;
        }

        @Override
        public SortDoc copy() {
            return new DoubleValueSortDoc(this.value1.copy(), this.value2.copy());
        }

        @Override
        public boolean lessThan(Object o) {
            DoubleValueSortDoc sd = (DoubleValueSortDoc)o;
            int comp = this.value1.compareTo(sd.value1);
            if (comp == -1) {
                return true;
            }
            if (comp == 1) {
                return false;
            }
            comp = this.value2.compareTo(sd.value2);
            if (comp == -1) {
                return true;
            }
            if (comp == 1) {
                return false;
            }
            return this.docId + this.docBase > sd.docId + sd.docBase;
        }

        @Override
        public int compareTo(Object o) {
            DoubleValueSortDoc sd = (DoubleValueSortDoc)o;
            int comp = this.value1.compareTo(sd.value1);
            if (comp == 0) {
                return this.value2.compareTo(sd.value2);
            }
            return comp;
        }
    }

    class SingleValueSortDoc
    extends SortDoc {
        protected SortValue value1;

        @Override
        public void setNextReader(LeafReaderContext context) throws IOException {
            this.ord = context.ord;
            this.value1.setNextReader(context);
        }

        @Override
        public void reset() {
            this.docId = -1;
            this.value1.reset();
        }

        @Override
        public void setValues(int docId) throws IOException {
            this.docId = docId;
            this.value1.setCurrentValue(docId);
        }

        @Override
        public void setValues(SortDoc sortDoc) throws IOException {
            this.docId = sortDoc.docId;
            this.ord = sortDoc.ord;
            this.value1.setCurrentValue(((SingleValueSortDoc)sortDoc).value1);
        }

        public SingleValueSortDoc(SortValue value1) {
            this.value1 = value1;
        }

        @Override
        public SortDoc copy() {
            return new SingleValueSortDoc(this.value1.copy());
        }

        @Override
        public boolean lessThan(Object o) {
            SingleValueSortDoc sd = (SingleValueSortDoc)o;
            int comp = this.value1.compareTo(sd.value1);
            if (comp == -1) {
                return true;
            }
            if (comp == 1) {
                return false;
            }
            return this.docId + this.docBase > sd.docId + sd.docBase;
        }

        public int compareTo(Object o) {
            SingleValueSortDoc sd = (SingleValueSortDoc)o;
            return this.value1.compareTo(sd.value1);
        }

        @Override
        public String toString() {
            return this.docId + ":" + this.value1.toString();
        }
    }

    class SortDoc {
        protected int docId = -1;
        protected int ord = -1;
        protected int docBase = -1;
        private SortValue[] sortValues;

        public SortDoc() {
        }

        public void setNextReader(LeafReaderContext context) throws IOException {
            this.ord = context.ord;
            for (SortValue value : this.sortValues) {
                value.setNextReader(context);
            }
        }

        public void reset() {
            this.docId = -1;
        }

        public void setValues(int docId) throws IOException {
            this.docId = docId;
            for (SortValue sortValue : this.sortValues) {
                sortValue.setCurrentValue(docId);
            }
        }

        public void setValues(SortDoc sortDoc) throws IOException {
            this.docId = sortDoc.docId;
            this.ord = sortDoc.ord;
            SortValue[] vals = sortDoc.sortValues;
            for (int i = 0; i < vals.length; ++i) {
                this.sortValues[i].setCurrentValue(vals[i]);
            }
        }

        public SortDoc(SortValue[] sortValues) {
            this.sortValues = sortValues;
        }

        public SortDoc copy() {
            SortValue[] svs = new SortValue[this.sortValues.length];
            for (int i = 0; i < this.sortValues.length; ++i) {
                svs[i] = this.sortValues[i].copy();
            }
            return new SortDoc(svs);
        }

        public boolean lessThan(Object o) {
            if (this.docId == -1) {
                return true;
            }
            SortDoc sd = (SortDoc)o;
            SortValue[] sortValues1 = sd.sortValues;
            for (int i = 0; i < this.sortValues.length; ++i) {
                int comp = this.sortValues[i].compareTo(sortValues1[i]);
                if (comp < 0) {
                    return true;
                }
                if (comp <= 0) continue;
                return false;
            }
            return this.docId + this.docBase < sd.docId + sd.docBase;
        }

        public String toString() {
            return "";
        }
    }

    class SortQueue
    extends PriorityQueue<SortDoc> {
        private SortDoc proto;
        private Object[] cache;

        public SortQueue(int len, SortDoc proto) {
            super(len);
            this.proto = proto;
        }

        @Override
        protected boolean lessThan(SortDoc t1, SortDoc t2) {
            return t1.lessThan(t2);
        }

        private void populate() {
            Object[] heap = this.getHeapArray();
            this.cache = new SortDoc[heap.length];
            for (int i = 1; i < heap.length; ++i) {
                this.cache[i] = heap[i] = this.proto.copy();
            }
            this.size = this.maxSize;
        }

        private void reset() {
            Object[] heap = this.getHeapArray();
            if (this.cache != null) {
                System.arraycopy(this.cache, 1, heap, 1, heap.length - 1);
                this.size = this.maxSize;
            } else {
                this.populate();
            }
        }
    }
}

