/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.api;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.Reader;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.solr.api.Api;
import org.apache.solr.api.SpecProvider;
import org.apache.solr.api.V2HttpCall;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.common.util.Utils;
import org.apache.solr.common.util.ValidatingJsonMap;
import org.apache.solr.core.PluginBag;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.handler.RequestHandlerUtils;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrRequestHandler;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.AuthorizationContext;
import org.apache.solr.security.PermissionNameProvider;
import org.apache.solr.util.CommandOperation;
import org.apache.solr.util.JsonSchemaValidator;
import org.apache.solr.util.PathTrie;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiBag {
    private final boolean isCoreSpecific;
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Map<String, PathTrie<Api>> apis = new ConcurrentHashMap<String, PathTrie<Api>>();
    public static final String APISPEC_LOCATION = "apispec/";
    public static final String INTROSPECT = "/_introspect";
    public static final SpecProvider EMPTY_SPEC = () -> ValidatingJsonMap.EMPTY;
    public static final String HANDLER_NAME = "handlerName";
    public static final Set<String> KNOWN_TYPES = ImmutableSet.of((Object)"string", (Object)"boolean", (Object)"list", (Object)"int", (Object)"double", (Object)"object", (Object[])new String[0]);

    public ApiBag(boolean isCoreSpecific) {
        this.isCoreSpecific = isCoreSpecific;
    }

    public synchronized void register(Api api, Map<String, String> nameSubstitutes) {
        try {
            this.validateAndRegister(api, nameSubstitutes);
        }
        catch (Exception e) {
            log.error("Unable to register plugin:" + api.getClass().getName() + "with spec :" + Utils.toJSONString((Object)api.getSpec()), (Throwable)e);
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
    }

    private void validateAndRegister(Api api, Map<String, String> nameSubstitutes) {
        ValidatingJsonMap spec = api.getSpec();
        IntrospectApi introspect = new IntrospectApi(api, this.isCoreSpecific);
        List methods = spec.getList("methods", ValidatingJsonMap.ENUM_OF, (Object)SolrRequest.SUPPORTED_METHODS);
        for (String method : methods) {
            ValidatingJsonMap url;
            ValidatingJsonMap params;
            PathTrie<Api> registry = this.apis.get(method);
            if (registry == null) {
                registry = new PathTrie((Set<String>)ImmutableSet.of((Object)"_introspect"));
                this.apis.put(method, registry);
            }
            if ((params = (url = spec.getMap("url", ValidatingJsonMap.NOT_NULL)).getMap("params", null)) != null) {
                for (Object o : params.keySet()) {
                    ValidatingJsonMap param = params.getMap(o.toString(), ValidatingJsonMap.NOT_NULL);
                    param.get("type", ValidatingJsonMap.ENUM_OF, KNOWN_TYPES);
                }
            }
            List paths = url.getList("paths", ValidatingJsonMap.NOT_NULL);
            ValidatingJsonMap parts = url.getMap("parts", null);
            if (parts != null) {
                Set<String> wildCardNames = this.getWildCardNames(paths);
                for (Object o : parts.keySet()) {
                    if (!wildCardNames.contains(o.toString())) {
                        throw new RuntimeException("" + o + " is not a valid part name");
                    }
                    ValidatingJsonMap pathMeta = parts.getMap(o.toString(), ValidatingJsonMap.NOT_NULL);
                    pathMeta.get("type", ValidatingJsonMap.ENUM_OF, (Object)ImmutableSet.of((Object)"enum", (Object)"string", (Object)"int", (Object)"number", (Object)"boolean"));
                }
            }
            this.verifyCommands(api.getSpec());
            for (String path : paths) {
                registry.insert(path, nameSubstitutes, api);
                ApiBag.registerIntrospect(nameSubstitutes, registry, path, (Api)introspect);
            }
        }
    }

    public static void registerIntrospect(Map<String, String> nameSubstitutes, PathTrie<Api> registry, String path, Api introspect) {
        int lastIdx;
        String itemAt;
        List<String> l = PathTrie.getPathSegments(path);
        ApiBag.registerIntrospect(l, registry, nameSubstitutes, introspect);
        for (int i = lastIdx = l.size() - 1; i >= 0 && PathTrie.templateName(itemAt = l.get(i)) != null; --i) {
            l.remove(i);
            if (registry.lookup(l, new HashMap<String, String>()) != null) break;
            ApiBag.registerIntrospect(l, registry, nameSubstitutes, introspect);
        }
    }

    static void registerIntrospect(List<String> l, PathTrie<Api> registry, Map<String, String> substitutes, Api introspect) {
        ArrayList<String> copy = new ArrayList<String>(l);
        copy.add("_introspect");
        registry.insert(copy, substitutes, introspect);
    }

    public static Map<String, JsonSchemaValidator> getParsedSchema(ValidatingJsonMap commands) {
        HashMap<String, JsonSchemaValidator> validators = new HashMap<String, JsonSchemaValidator>();
        for (Object o : commands.entrySet()) {
            Map.Entry cmd = (Map.Entry)o;
            try {
                validators.put((String)cmd.getKey(), new JsonSchemaValidator((Map)cmd.getValue()));
            }
            catch (Exception e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error in api spec", (Throwable)e);
            }
        }
        return validators;
    }

    private void verifyCommands(ValidatingJsonMap spec) {
        ValidatingJsonMap commands = spec.getMap("commands", null);
        if (commands == null) {
            return;
        }
        ApiBag.getParsedSchema(commands);
    }

    private Set<String> getWildCardNames(List<String> paths) {
        HashSet<String> wildCardNames = new HashSet<String>();
        for (String path : paths) {
            List<String> p = PathTrie.getPathSegments(path);
            for (String s : p) {
                String wildCard = PathTrie.templateName(s);
                if (wildCard == null) continue;
                wildCardNames.add(wildCard);
            }
        }
        return wildCardNames;
    }

    public Api lookup(String path, String httpMethod, Map<String, String> parts) {
        if (httpMethod == null) {
            for (PathTrie<Api> trie : this.apis.values()) {
                Api api = trie.lookup(path, parts);
                if (api == null) continue;
                return api;
            }
            return null;
        }
        PathTrie<Api> registry = this.apis.get(httpMethod);
        if (registry == null) {
            return null;
        }
        return registry.lookup(path, parts);
    }

    public static SpecProvider getSpec(String name) {
        return () -> ValidatingJsonMap.parse((String)(APISPEC_LOCATION + name + ".json"), (String)APISPEC_LOCATION);
    }

    public static List<Api> wrapRequestHandlers(SolrRequestHandler rh, String ... specs) {
        ImmutableList.Builder b = ImmutableList.builder();
        for (String spec : specs) {
            b.add((Object)new ReqHandlerToApi(rh, ApiBag.getSpec(spec)));
        }
        return b.build();
    }

    public PathTrie<Api> getRegistry(String method) {
        return this.apis.get(method);
    }

    public void registerLazy(PluginBag.PluginHolder<SolrRequestHandler> holder, PluginInfo info) {
        String specName = info.attributes.get("spec");
        if (specName == null) {
            specName = "emptySpec";
        }
        this.register(new LazyLoadedApi(ApiBag.getSpec(specName), holder), Collections.singletonMap(HANDLER_NAME, info.attributes.get("name")));
    }

    public static SpecProvider constructSpec(PluginInfo info) {
        String specObj;
        String string = specObj = info == null ? null : info.attributes.get("spec");
        if (specObj == null) {
            specObj = "emptySpec";
        }
        if (specObj instanceof Map) {
            Map map = (Map)((Object)specObj);
            return () -> ValidatingJsonMap.getDeepCopy((Map)map, (int)4, (boolean)false);
        }
        return ApiBag.getSpec(specObj);
    }

    public static List<CommandOperation> getCommandOperations(Reader reader, Map<String, JsonSchemaValidator> validators, boolean validate) {
        List<CommandOperation> parsedCommands = null;
        try {
            parsedCommands = CommandOperation.parse(reader);
        }
        catch (IOException e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)e);
        }
        if (validators == null || !validate) {
            return parsedCommands;
        }
        List<CommandOperation> commandsCopy = CommandOperation.clone(parsedCommands);
        for (CommandOperation cmd : commandsCopy) {
            JsonSchemaValidator validator = validators.get(cmd.name);
            if (validator == null) {
                cmd.addError(StrUtils.formatString((String)"Unknown operation ''{0}'' available ops are ''{1}''", (Object[])new Object[]{cmd.name, validators.keySet()}));
                continue;
            }
            List<String> errs = validator.validateJson(cmd.getCommandData());
            if (errs == null) continue;
            for (String err : errs) {
                cmd.addError(err);
            }
        }
        List<Map> errs = CommandOperation.captureErrors(commandsCopy);
        if (!errs.isEmpty()) {
            throw new ExceptionWithErrObject(SolrException.ErrorCode.BAD_REQUEST, "Error in command payload", errs);
        }
        return commandsCopy;
    }

    public static class LazyLoadedApi
    extends Api {
        private final PluginBag.PluginHolder<SolrRequestHandler> holder;
        private Api delegate;

        protected LazyLoadedApi(SpecProvider specProvider, PluginBag.PluginHolder<SolrRequestHandler> lazyPluginHolder) {
            super(specProvider);
            this.holder = lazyPluginHolder;
        }

        @Override
        public void call(SolrQueryRequest req, SolrQueryResponse rsp) {
            if (!this.holder.isLoaded()) {
                this.delegate = new ReqHandlerToApi(this.holder.get(), EMPTY_SPEC);
            }
            this.delegate.call(req, rsp);
        }
    }

    public static class ExceptionWithErrObject
    extends SolrException {
        private List<Map> errs;

        public ExceptionWithErrObject(SolrException.ErrorCode code, String msg, List<Map> errs) {
            super(code, msg);
            this.errs = errs;
        }

        public List<Map> getErrs() {
            return this.errs;
        }
    }

    public static class ReqHandlerToApi
    extends Api
    implements PermissionNameProvider {
        SolrRequestHandler rh;

        public ReqHandlerToApi(SolrRequestHandler rh, SpecProvider spec) {
            super(spec);
            this.rh = rh;
        }

        @Override
        public void call(SolrQueryRequest req, SolrQueryResponse rsp) {
            this.rh.handleRequest(req, rsp);
        }

        @Override
        public PermissionNameProvider.Name getPermissionName(AuthorizationContext ctx) {
            if (this.rh instanceof PermissionNameProvider) {
                return ((PermissionNameProvider)((Object)this.rh)).getPermissionName(ctx);
            }
            return null;
        }
    }

    public static class IntrospectApi
    extends Api {
        Api baseApi;
        final boolean isCoreSpecific;

        public IntrospectApi(Api base, boolean isCoreSpecific) {
            super(EMPTY_SPEC);
            this.baseApi = base;
            this.isCoreSpecific = isCoreSpecific;
        }

        @Override
        public void call(SolrQueryRequest req, SolrQueryResponse rsp) {
            ArrayList<ValidatingJsonMap> l;
            String cmd = req.getParams().get("command");
            ValidatingJsonMap result = null;
            if (cmd == null) {
                result = this.isCoreSpecific ? ValidatingJsonMap.getDeepCopy((Map)this.baseApi.getSpec(), (int)5, (boolean)true) : this.baseApi.getSpec();
            } else {
                ValidatingJsonMap specCopy = ValidatingJsonMap.getDeepCopy((Map)this.baseApi.getSpec(), (int)5, (boolean)true);
                ValidatingJsonMap commands = specCopy.getMap("commands", null);
                if (commands != null) {
                    ValidatingJsonMap m = commands.getMap(cmd, null);
                    specCopy.put("commands", Collections.singletonMap(cmd, m));
                }
                result = specCopy;
            }
            if (this.isCoreSpecific) {
                List<String> pieces;
                List<String> list = pieces = req.getHttpSolrCall() == null ? null : ((V2HttpCall)req.getHttpSolrCall()).pieces;
                if (pieces != null) {
                    String prefix = "/" + pieces.get(0) + "/" + pieces.get(1);
                    List paths = result.getMap("url", ValidatingJsonMap.NOT_NULL).getList("paths", ValidatingJsonMap.NOT_NULL);
                    result.getMap("url", ValidatingJsonMap.NOT_NULL).put("paths", paths.stream().map(s -> prefix + s).collect(Collectors.toList()));
                }
            }
            if ((l = (ArrayList<ValidatingJsonMap>)rsp.getValues().get("spec")) == null) {
                l = new ArrayList<ValidatingJsonMap>();
                rsp.getValues().add("spec", l);
            }
            l.add(result);
            RequestHandlerUtils.addExperimentalFormatWarning(rsp);
        }
    }
}

