/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import org.apache.kafka.common.message.DeleteTopicsRequestData;
import org.apache.kafka.common.message.DeleteTopicsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.DeleteTopicsResponse;

public class DeleteTopicsRequest
extends AbstractRequest {
    private static final String TOPICS_KEY_NAME = "topics";
    private static final String TIMEOUT_KEY_NAME = "timeout";
    private static final Schema DELETE_TOPICS_REQUEST_V0;
    private static final Schema DELETE_TOPICS_REQUEST_V1;
    private static final Schema DELETE_TOPICS_REQUEST_V2;
    private static final Schema DELETE_TOPICS_REQUEST_V3;
    private DeleteTopicsRequestData data;
    private final short version;

    public static Schema[] schemaVersions() {
        return new Schema[]{DELETE_TOPICS_REQUEST_V0, DELETE_TOPICS_REQUEST_V1, DELETE_TOPICS_REQUEST_V2, DELETE_TOPICS_REQUEST_V3};
    }

    private DeleteTopicsRequest(DeleteTopicsRequestData data, short version) {
        super(ApiKeys.DELETE_TOPICS, version);
        this.data = data;
        this.version = version;
    }

    public DeleteTopicsRequest(Struct struct, short version) {
        super(ApiKeys.DELETE_TOPICS, version);
        this.data = new DeleteTopicsRequestData(struct, version);
        this.version = version;
    }

    @Override
    protected Struct toStruct() {
        return this.data.toStruct(this.version);
    }

    public DeleteTopicsRequestData data() {
        return this.data;
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        DeleteTopicsResponseData response = new DeleteTopicsResponseData();
        if (this.version >= 1) {
            response.setThrottleTimeMs(throttleTimeMs);
        }
        ApiError apiError = ApiError.fromThrowable(e);
        for (String topic : this.data.topicNames()) {
            response.responses().add(new DeleteTopicsResponseData.DeletableTopicResult().setName(topic).setErrorCode(apiError.error().code()));
        }
        return new DeleteTopicsResponse(response);
    }

    public static DeleteTopicsRequest parse(ByteBuffer buffer, short version) {
        return new DeleteTopicsRequest(ApiKeys.DELETE_TOPICS.parseRequest(version, buffer), version);
    }

    static {
        DELETE_TOPICS_REQUEST_V3 = DELETE_TOPICS_REQUEST_V2 = (DELETE_TOPICS_REQUEST_V1 = (DELETE_TOPICS_REQUEST_V0 = new Schema(new Field(TOPICS_KEY_NAME, new ArrayOf(Type.STRING), "An array of topics to be deleted."), new Field(TIMEOUT_KEY_NAME, Type.INT32, "The time in ms to wait for a topic to be completely deleted on the controller node. Values <= 0 will trigger topic deletion and return immediately"))));
    }

    public static class Builder
    extends AbstractRequest.Builder<DeleteTopicsRequest> {
        private DeleteTopicsRequestData data;

        public Builder(DeleteTopicsRequestData data) {
            super(ApiKeys.DELETE_TOPICS);
            this.data = data;
        }

        @Override
        public DeleteTopicsRequest build(short version) {
            return new DeleteTopicsRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

